#---------------------------------------------#
# <aw:description>Template for an Enumeration inspired by Java Developer ConnectionSM (JDC) Tech Tips, February 5, 2002. (http://developer.java.sun.com/developer/JDCTechTips/2002/tt0205.html#tip2)</aw:description>
# <aw:version>1.1</aw:version>
# <aw:date>04/05/2003</aw:date>
# <aw:author>Jean-Nol Meunier (meunier@aonix.fr)</aw:author>
#---------------------------------------------#

<aw:import>java.io.ObjectStreamException</aw:import>

<aw:field>
	/** Next enumeration number */
	private static int nextIndex = 0;
	/** Enumeration number */
	private final int index = nextIndex++;
	/** Enumeration name */
	private final transient String enumName;

	/** Enumeration values */
	// manual code: replace "ENUMERATION_VALUE_<i>" by the real enumeration identifiers  
	private static final <aw:className/> ENUMERATION_VALUE_1;    
	private static final <aw:className/> ENUMERATION_VALUE_2; 
	private static final <aw:className/> ENUMERATION_VALUE_3;    
   
	/** Array of enumeration values */
	// manual code: replace "ENUMERATION_VALUE_<i>" by the real enumeration identifiers  
	// and replace "ENUMERATION_VALUE_NAME_<i>" by the real enumeration names  
	private static final <aw:className/> VALUES[] = {
		ENUMERATION_VALUE_1 = new <aw:className/>("ENUMERATION_VALUE_NAME_1"),
		ENUMERATION_VALUE_2 = new <aw:className/>("ENUMERATION_VALUE_NAME_2"),
		ENUMERATION_VALUE_3 = new <aw:className/>("ENUMERATION_VALUE_NAME_3")
	};

</aw:field>

<aw:constructor name="c1">
	/**
	 * Constructor of the enumeration object. <br>
	 *
	 * This constructor should remain private.
	 * 
	 * @param aName the name of the enumeration
	 */
	private <aw:className/>(String name) {
		this.enumName = name;
	}

</aw:constructor>

<aw:method name="toString">
	/**
	 * Returns the enumeration name.
	 *
	 * @return the enumeration name.
	 */
	public String toString() {
		return this.enumName;
	}

</aw:method>

<aw:method name="readResolve">
	/** 
	 * Used for deserialization. <br>
	 * 
	 * Returns an enumeration object after deserialization. Enables to keep the same
	 * order, making possible comparison of enumeration values with the "=" symbol.
	 * 
	 * @return an enumeration object after deserialization
	 * @throws ObjectStreamException if an error occured
	 */
	private Object readResolve() throws ObjectStreamException {
		return VALUES[index];
	}       

</aw:method>	