#---------------------------------------------#
# <aw:description>Template for a Singleton</aw:description>
# <aw:version>1.0</aw:version>
# <aw:date>06/21/2003</aw:date>
# <aw:author>Ferret Renaud</aw:author>
# <aw:description>inspired by Peter Haggar paper (http://www-106.ibm.com/developerworks/java/library/j-dcl.html)</aw:description>
#---------------------------------------------#

<aw:field>
	/** This is the default instance used for this singleton. */
	private static <aw:className/> defaultInstance;

</aw:field>

<aw:constructor name="c1">
	/**
	 * Constructor of the object. <br>
	 *
	 * This constructor should remain private
	 */
	private <aw:className/>() {
		super();
		// Put your code here
	}

</aw:constructor>

<aw:method name="getInstance">
	/**
	 * Gets the unique instance of this class. <br>
	 *
	 * Using Double-checked locking. <br>
	 * See <a href="http://www-106.ibm.com/developerworks/java/library/j-dcl.html">this page</a>
	 * for more information. <br>
	 *
	 * @return the unique instance of this class
	 */
	public final static <aw:className/> getInstance() {
		if (<aw:className/>.defaultInstance == null) {
			synchronized(<aw:className/>.class) {
				<aw:className/> inst = <aw:className/>.defaultInstance;
				if (inst == null) {
					synchronized(<aw:className/>.class) {
						inst = new <aw:className/>();
					}
					<aw:className/>.defaultInstance = inst;
				}
			}
		}
		return <aw:className/>.defaultInstance;		
	}

</aw:method>

<aw:method name="main">
	/**
	 * For test.
	 *
	 * @param args
	 */
	public static void main(String[] args) {   
		// The first and only instance of the Singleton
		<aw:className/> mySingleton = <aw:className/>.getInstance();
	}

</aw:method>