package com.aston;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/**
 * Basic action class for everything.
 * 
 * @author 
 * <ul>
 * 	<li><a href="renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version V1.0
 */
public abstract class BasicMethodAction implements IObjectActionDelegate {
	protected final static String NEWLINE =
		System.getProperty("line.separator");

	protected IStructuredSelection selection; 

	/**
	 * Constructor of the object.
	 */
	protected BasicMethodAction() {
		super();
		LogMessage.getInstance()
				.log("-> BasicMethodAction.BasicMethodAction()");
	}

	/**
	 * Sets the active part for the delegate.  
	 * The active part is commonly used to get a working context for the action, such
	 * as the shell for any dialog which is needed.
	 * <p>
	 * This method will be called every time the action appears in a popup menu.  The
	 * targetPart may change with each invocation.
	 * </p>
	 *
	 * @param action the action proxy that handles presentation portion of the action
	 * @param targetPart the new part target
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		LogMessage.getInstance().log(
				"-> BasicMethodAction.setActivePart(action, targetPart)");
		if (targetPart instanceof PackageExplorerPart) {
			PackageExplorerPart pep = (PackageExplorerPart) targetPart;
			TreeViewer tv = pep.getTreeViewer();
			if (tv.getSelection() instanceof StructuredSelection) {
				StructuredSelection ss =
					(StructuredSelection) tv.getSelection();
					this.selection = ss;
			}
		}
	}

	/**
	 * Performs this action.
	 * <p>
	 * This method is called by the proxy action when the action has been
	 * triggered. Implement this method to do the actual work.
	 * </p><p>
	 * <b>Note:</b> If the action delegate also implements
	 * <code>IActionDelegate2</code>, then this method is not invoked but
	 * instead the <code>runWithEvent(IAction, Event)</code> method is called.
	 * </p>
	 *
	 * @param action the action proxy that handles the presentation portion of the
	 *   action
	 */
	public void run(IAction action) {
		LogMessage.getInstance().log("-> BasicMethodAction.run(action)");
		if (this.selection != null) {
			this.doAction();
		}
	}

	/**
	 * Notifies this action delegate that the selection in the workbench has changed.
	 * <p>
	 * Implementers can use this opportunity to change the availability of the
	 * action or to modify other presentation properties.
	 * </p><p>
	 * When the selection changes, the action enablement state is updated based on
	 * the criteria specified in the plugin.xml file. Then the delegate is notified
	 * of the selection change regardless of whether the enablement criteria in the
	 * plugin.xml file is met.
	 * </p>
	 *
	 * @param action the action proxy that handles presentation portion of 
	 * 		the action
	 * @param selection the current selection, or <code>null</code> if there
	 * 		is no selection.
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		// Does nothing here
	}

	/**
	 * Shows a message if the method already exist.
	 * 
	 * @param aMessage the message
	 * @param aTitle the title
	 */
	protected void showMessage(String aTitle, String aMessage) {
		LogMessage.getInstance().log(
				"-> BasicMethodAction.showMessage(aTitle, aMessage)");
		Shell shell = new Shell();
		MessageDialog.openInformation(
			shell, aTitle, aMessage);
		shell = null;
	}

	/**
	 * Do what must be done.
	 */
	protected abstract void doAction();
	
	/**
	 * Returns the global path.
	 * 
	 * Means, where does the user has decided to make a new file, using 
	 * right click popup menu or toolbar options.
	 * 
	 * @return the path where to create the new file.
	 */
	public String getGlobalPath() {
		LogMessage.getInstance().log("-> BasicMethodAction.getGlobalPath()");
		if (this.selection != null
			&& this.selection.isEmpty() == false
			&& this.selection instanceof IStructuredSelection) {
			IStructuredSelection ssel = (IStructuredSelection) this.selection;
//			if (ssel.size() > 1) {
//				return "/";
//			}
			Object obj = ssel.getFirstElement();
			if (obj instanceof IResource) {
				IContainer container;
				if (obj instanceof IContainer) {
					container = (IContainer) obj;
				} else {
					container = ((IResource) obj).getParent();
				}
				return container.getFullPath().toString();
			} else if (obj instanceof Openable) {
				return ((Openable) obj).getPath().toString();
				//			} else  {
				//				System.out.println(obj.getClass());
			}
		}
		return "/";
	}

}
