package com.aston;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;

import com.aston.utils.Utils;

/**
 * Basic action class for a Java file selection.
 * 
 * @author 
 * <ul>
 * 	<li><a href="renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version V1.0
 */
public abstract class BasicMethodActionICompilationUnit
	extends BasicMethodAction {

	protected IType selectedClass;
	protected CompilationUnit selectedCompilationUnit; 

	/**
	 * Constructor of the object.
	 */
	protected BasicMethodActionICompilationUnit() {
		super();
		LogMessage
				.getInstance()
				.log(
						"-> BasicMethodActionICompilationUnit.BasicMethodActionICompilationUnit()");
	}

	/**
	 * Sets the active part for the delegate.  
	 * The active part is commonly used to get a working context for the action, such
	 * as the shell for any dialog which is needed.
	 * <p>
	 * This method will be called every time the action appears in a popup menu.  The
	 * targetPart may change with each invocation.
	 * </p>
	 *
	 * @param action the action proxy that handles presentation portion of the action
	 * @param targetPart the new part target
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		LogMessage
				.getInstance()
				.log(
						"-> BasicMethodActionICompilationUnit.setActivePart(action, targetPart)");
		super.setActivePart(action, targetPart);
		if (super.selection.getFirstElement() instanceof CompilationUnit) {
			CompilationUnit cu =
				(CompilationUnit) super.selection.getFirstElement();
			try {
				IType[] allTypes = cu.getAllTypes();
				for (int i = 0; i < allTypes.length; i++) {
					if (allTypes[i].isClass()) {
						this.selectedClass = allTypes[i];
						this.selectedCompilationUnit = cu;
						return;
					}
				}
			} catch (JavaModelException e) {
				// e.printStackTrace();
			}
		}
	}

	/**
	 * Gets the selected file name.
	 * 
	 * @return the selected file name, Toto.java.
	 */
	public String getFileName() {
		LogMessage.getInstance().log(
				"-> BasicMethodActionICompilationUnit.getFileName()");
		if (this.selectedClass != null) {
			return this.selectedClass.getElementName().concat(".java");
		}
		return null;
	}

	/**
	 * Gets the selected class name.
	 * 
	 * @return the selected class name, com.test.Toto
	 */
	public String getClassName() {
		LogMessage.getInstance().log(
				"-> BasicMethodActionICompilationUnit.getClassName()");
		if (this.selectedClass != null) {
			return this.selectedClass.getFullyQualifiedName();
		}
		return null;
	}

	/**
	 * Gets the selected short class name.
	 * 
	 * @return the selected short class name, Toto
	 */
	public String getShortClassName() {
		LogMessage.getInstance().log(
				"-> BasicMethodActionICompilationUnit.getShortClassName()");
		if (this.selectedClass != null) {
			return this.selectedClass.getElementName();
		}
		return null;
	}

	/**
	 * Gets the selected file path.
	 * 
	 * @return the selected file path, /Toto/file.jsp.
	 */
	public String getFilePath() {
		LogMessage.getInstance().log(
				"-> BasicMethodActionICompilationUnit.getFilePath()");
		if (this.selectedClass != null) {
			return this.selectedClass.getPath().toString();
		}
		return null;
	}

	/**
	 * Gets the project path.
	 * 
	 * @return the project path, /Toto
	 */
	public String getProjectPath() {
		LogMessage.getInstance().log(
				"-> BasicMethodActionICompilationUnit.getProjectPath()");
		return Utils.getProjectPath(this.selectedClass.getPath().toString());
	}

}
