package com.aston;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;

/**
 * Basic action class for a non Java file selection (txt, jsp, html ...).
 * 
 * @author 
 * <ul>
 * 	<li><a href="renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version V1.0
 */
public abstract class BasicMethodActionIFile extends BasicMethodAction {

	protected IFile selectedFile;
 
	/**
	 * Constructor of the object.
	 */
	protected BasicMethodActionIFile() {
		super();
		LogMessage.getInstance().log(
				"-> BasicMethodActionIFile.BasicMethodActionIFile()");
	}

	/**
	 * Sets the active part for the delegate.  
	 * The active part is commonly used to get a working context for the action, such
	 * as the shell for any dialog which is needed.
	 * <p>
	 * This method will be called every time the action appears in a popup menu.  The
	 * targetPart may change with each invocation.
	 * </p>
	 *
	 * @param action the action proxy that handles presentation portion of the action
	 * @param targetPart the new part target
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		LogMessage.getInstance().log(
				"-> BasicMethodActionIFile.setActivePart(action, targetPart)");
		super.setActivePart(action, targetPart);
		if (super.selection != null) {
			if (super.selection.getFirstElement()
				instanceof org.eclipse.core.internal.resources.File) {
				this.selectedFile =
					(org.eclipse.core.internal.resources.File) super
						.selection
						.getFirstElement();
			}
		}
	}

	/**
	 * Gets the selected file name.
	 * 
	 * @return the selected file name, toto.jsp.
	 */
	public String getFileName() {
		LogMessage.getInstance().log("-> BasicMethodActionIFile.getFileName()");
		if (this.selectedFile != null) {
			return this.selectedFile.getName();
		}
		return null;
	}

	/**
	 * Gets the selected file path.
	 * 
	 * @return the selected file path, /Toto/file.jsp.
	 */
	public String getFilePath() {
		LogMessage.getInstance().log("-> BasicMethodActionIFile.getFilePath()");
		if (this.selectedFile != null) {
			return this.selectedFile.getFullPath().toString();
		}
		return null;
	}

	/**
	 * Gets the project path.
	 * 
	 * @return the project path, /Toto
	 */
	public String getProjectPath() {
		LogMessage.getInstance().log(
				"-> BasicMethodActionIFile.getProjectPath()");
		return this.selectedFile.getProject().getFullPath().toString();
	}

	/**
	 * Gets the file extension.
	 * 
	 * @return the file extension, .jsp
	 */
	public String getFileExtension() {
		LogMessage.getInstance().log(
				"-> BasicMethodActionIFile.getFileExtension()");
		return this.selectedFile.getFileExtension();
	}
}
