package com.aston.utils;


/**
 * This class does the same thing as the java.text.MessageFormat, 
 * but there is a critical bug in JDK 1.3 that is corrected here. 
 * 
 * Pattern can handle more than 10 holes.
 * 
 * This class is not used, but I keep it in case.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */ 
public final class MessageFormat {

	/**
	 * Constructor for MessageFormat.
	 */
	private MessageFormat() {
		super();
	}

	/**
	 * Fill all gap in the message.
	 * 
	 * @param aPattern a String like "Hello Mr {0}"
	 * @param someObjects an arrays that will fill all gaps, 
	 * like new String[] {"Kenedy"}
	 * 
	 * @return the pattern filled
	 */
	public static String format(String aPattern, Object[] someObjects) {
		return com.aston.utils.MessageFormat.doReplace(aPattern, someObjects);
	}

	/**
	 * Fill all gap in the message.
	 * 
	 * Unlike in JDK 1.3 version, this can handle more than 10 objects
	 * 
	 * @param aPattern a String like "Hello Mr {0}"
	 * @param someObjects an arrays that will fill all gaps, 
	 * like new String[] {"Kenedy"}
	 * 
	 * @return the pattern filled
	 */
	private static String doReplace(
		String aPattern,
		Object[] someObjects) {
		if (aPattern == null || someObjects == null) {
			return aPattern;
		}
		int length = aPattern.length();
		StringBuffer sb = new StringBuffer(length);
		for (int i = 0; i < length; i++) {
			char c = aPattern.charAt(i);
			if (c == '{') {
				int j = 0;
				for (j = i + 1; j < length; j++) {
					if (aPattern.charAt(j) == '}') {
						break;
					}
				}
				int id = MessageFormat.asInt(aPattern.substring(i + 1, j));
				if (id != -1) {
					sb.append(someObjects[id]);
					i = j;
					continue;
				}
			}
			sb.append(c);
		}
		return sb.toString();
	}

	/**
	 * Transforms a string into an int
	 * 
	 * @param anElement a String that should be an int value
	 * 
	 * @return the integer or -1 if the string is not an integer
	 */
	private static int asInt(String anElement) {
		try {
			return Integer.parseInt(anElement);
		} catch (NumberFormatException nfe) {
		}
		return -1;
	}
}
