package com.aston.wizards.applet;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.Marks;

/**
 * Wizard page to create a new Applet class. <p>
 * 
 * This class is inspired of the org.eclipse.jdt.ui.wizards.NewClassWizardPage.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */
public class NewAppletCreationWizardPage extends com.aston.NewTypeWizardPage {
 
	protected final static String SETTINGS_CREATE_START = "create_start";
	protected final static String SETTINGS_CREATE_STOP = "create_stop";
	protected final static String SETTINGS_CREATE_INITDESTROY =
		"create_initdestroy";
	protected final static String SETTINGS_CREATE_APPLETINFO =
		"create_appletinfo";

	/**
	 * Constructor of the object. 
	 */
	public NewAppletCreationWizardPage() {
		super(true, "NewAppletCreationWizardPage", "applet");
	}

	/**
	 * The wizard owning this page is responsible for calling this method 
	 * with the current selection. The selection is used to 
	 * initialize the fields of the wizard page.
	 * 
	 * @param selection used to initialize the fields
	 */
	public void init(IStructuredSelection selection) {
		LogMessage.getInstance().log(
				"-> NewAppletCreationWizardPage.init(selection)");
		IJavaElement jelem = getInitialJavaElement(selection);
		initContainerPage(jelem);
		initTypePage(jelem);
		doStatusUpdate();

		boolean[] values = new boolean[6];
		for (int i = 0; i < values.length; i++) {
			values[i] = true;
		}

		IDialogSettings section =
			getDialogSettings().getSection(this.getName());
		if (section != null) {
			values[0] = section.getBoolean(SETTINGS_CREATE_INHERITED);
			values[1] = section.getBoolean(SETTINGS_CREATE_START);
			values[2] = section.getBoolean(SETTINGS_CREATE_CONSTR);
			values[3] = section.getBoolean(SETTINGS_CREATE_STOP);
			values[4] = section.getBoolean(SETTINGS_CREATE_INITDESTROY);
			values[5] = section.getBoolean(SETTINGS_CREATE_APPLETINFO);
		}
		setMethodStubSelection(values, true);
	}

	/**
	 * Returns the current selection state of the 'Create start' checkbox.
	 * 
	 * @return the selection state of the 'Create start' checkbox
	 */
	public boolean isCreateStart() {
		LogMessage.getInstance().log(
				"-> NewAppletCreationWizardPage.isCreateStart()");
		return this.fMethodStubsButtons.isSelected(1);
	}

	/**
	 * Returns the current selection state of the 'Create stop' checkbox.
	 * 
	 * @return the selection state of the 'Create stop' checkbox
	 */
	public boolean isCreateStop() {
		LogMessage.getInstance().log(
				"-> NewAppletCreationWizardPage.isCreateStop()");
		return this.fMethodStubsButtons.isSelected(3);
	}

	/**
	 * Returns the current selection state of the 'Create InitDestroy' checkbox.
	 * 
	 * @return the selection state of the 'Create InitDestroy' checkbox
	 */
	public boolean isCreateInitDestroy() {
		LogMessage.getInstance().log(
				"-> NewAppletCreationWizardPage.isCreateInitDestroy()");
		return this.fMethodStubsButtons.isSelected(4);
	}

	/**
	 * Returns the current selection state of the 'Create getAppletInfo' checkbox.
	 * 
	 * @return the selection state of the 'Create getAppletInfo' checkbox
	 */
	public boolean isCreateAppletInfo() {
		LogMessage.getInstance().log(
				"-> NewAppletCreationWizardPage.isCreateAppletInfo()");
		return this.fMethodStubsButtons.isSelected(5);
	}

	protected void updateSectionValues() {
		LogMessage.getInstance().log(
				"-> NewAppletCreationWizardPage.updateSectionValues()");
		super.updateSectionValues();
		IDialogSettings section =
			getDialogSettings().getSection(this.getName());
		section.put(SETTINGS_CREATE_START, isCreateStart());
		section.put(SETTINGS_CREATE_STOP, isCreateStop());
		section.put(SETTINGS_CREATE_APPLETINFO, isCreateAppletInfo());
		section.put(SETTINGS_CREATE_INITDESTROY, isCreateInitDestroy());
	}

	/**
	 * @see com.aston.NewTypeWizardPage#initThePage()
	 */
	protected void initThePage() {
		LogMessage.getInstance().log(
				"-> NewAppletCreationWizardPage.initThePage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.appletwizard"));
		setDescription(
			AstonWizardsPlugin.getResourceString("lg.label.willgenerateapplet"));

		String[] buttonNames3 =
			new String[] {
				AstonWizardsPlugin.getResourceString("lg.label.createim"),
				AstonWizardsPlugin.getResourceString("lg.label.createstart"),
				AstonWizardsPlugin.getResourceString("lg.label.createc"),
				AstonWizardsPlugin.getResourceString("lg.label.createstop"),
				AstonWizardsPlugin.getResourceString("lg.label.createinitdestroy"),
				AstonWizardsPlugin.getResourceString("lg.label.createappletinfo"),
				};
		this.fMethodStubsButtons =
			new SelectionButtonDialogFieldGroup(SWT.CHECK, buttonNames3, 2);
		this.fMethodStubsButtons.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.options"));
	}

	/**
	 * Builds the methods for the given type.
	 * 
	 * @param file the String loaded from the template file
	 * @param type the created type
	 * @param imports object used for importing classes
	 * @param monitor the monitor used during the process
	 * 
	 * @throws CoreException if a problem occured
	 */
	protected void createMethods(
		String file,
		IType type,
		ImportsManager imports,
		IProgressMonitor monitor)
		throws CoreException {
		LogMessage
				.getInstance()
				.log(
						"-> NewAppletCreationWizardPage.createMethods(file, type, imports, monitor)");
		Map m = loadXmlParts(file, MARK_METHOD, Marks.TOKEN_NAME);
		boolean doStart = isCreateStart();
		boolean doStop = isCreateStop();
		boolean doAppletInfo = isCreateAppletInfo();
		boolean doInitDestroy = isCreateInitDestroy();
		Iterator it = m.keySet().iterator();
		while (it.hasNext()) {
			String key = (String) it.next();
			String body = (String) m.get(key);
			if ((!doStart && "start".equals(key))
				|| (!doStop && "stop".equals(key))
				|| (!doAppletInfo && "getAppletInfo".equals(key))
				|| (!doInitDestroy
					&& ("init".equals(key) || "destroy".equals(key)))) {
				continue;
			}
			type.createMethod(body, null, false, monitor);
			body = null;
			key = null;
		}
		it = null;
		m.clear();
		m = null;
	}

	/**
	 * Adds specfic values to the Map of keys.
	 * 
	 * @param type type of the object
	 * @param imports the imports of the file
	 * @param monitor the progress bar
	 * @param values the current Map that contains values for the template
	 */
	protected void setSpecificValues(
		IType type,
		ImportsManager imports,
		IProgressMonitor monitor,
		Map values) {
		LogMessage
				.getInstance()
				.log(
						"-> NewAppletCreationWizardPage.setSpecificValues(type, imports, monitor, values)");
		// Does nothing
	}
}