package com.aston.wizards.designpattern;

import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.compiler.env.IConstants;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewTypeWizardPage;

/**
 * Wizard page to create a new enumeration class. <p>
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author
 * <ul>
 *     <li><a href="mailto:jean-noel.meunier@aonix.fr">Jean-Noel Meunier</a></li>
 * </ul> 
 */
public class NewEnumerationCreationWizardPage extends NewTypeWizardPage {
 
	/**
	 * Constructor of the object.
	 */
	public NewEnumerationCreationWizardPage() {
		super(true, "NewEnumerationCreationWizardPage", "enumeration");
		LogMessage
				.getInstance()
				.log(
						"-> NewEnumerationCreationWizardPage.NewEnumerationCreationWizardPage()");
	}

	/**
	 * Initialize the all page.
	 */
	protected void initThePage() {
		LogMessage.getInstance().log(
				"-> NewEnumerationCreationWizardPage.initThePage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.enumwizard"));
		setDescription(AstonWizardsPlugin.getResourceString("lg.label.enumwillgen"));
		String buttonNames3[] =
			{
				AstonWizardsPlugin.getResourceString("lg.label.createim"),
				AstonWizardsPlugin.getResourceString("lg.label.createmain"),
				AstonWizardsPlugin.getResourceString("lg.label.createc")};
		super.fMethodStubsButtons =
			new SelectionButtonDialogFieldGroup(SWT.CHECK, buttonNames3, 2);
		super.fMethodStubsButtons.setLabelText(AstonWizardsPlugin.getResourceString("lg.label.options"));	
		setModifiers(IConstants.AccFinal | IConstants.AccPublic, true);
	}

	/**
	 * The wizard owning this page is responsible for calling this method 
	 * with the current selection. The selection is used to 
	 * initialize the fields of the wizard page.
	 * 
	 * @param selection used to initialize the fields
	 */
	public void init(IStructuredSelection selection) {
		LogMessage.getInstance().log(
				"-> NewEnumerationCreationWizardPage.init(selection)");
		IJavaElement jelem = getInitialJavaElement(selection);
		initContainerPage(jelem);
		initTypePage(jelem);
		doStatusUpdate();
		boolean values[] = new boolean[3];
		values[2] = true;
		IDialogSettings section = getDialogSettings().getSection(getName());
		if (section != null) {
			values[0] = section.getBoolean(SETTINGS_CREATE_INHERITED);
			values[1] = section.getBoolean(SETTINGS_CREATE_MAIN);
			values[2] = section.getBoolean(SETTINGS_CREATE_CONSTR);
		}
		setMethodStubSelection(values, true);
	}

	/**
	 * Adds specfic values to the Map of keys.
	 * 
	 * @param type type of the object
	 * @param imports the imports of the file
	 * @param monitor the progress bar
	 * @param currentValues the current Map that contains values for the template
	 */
	protected void setSpecificValues(
		IType itype,
		ImportsManager importsmanager,
		IProgressMonitor iprogressmonitor,
		Map map) {
		LogMessage
				.getInstance()
				.log(
						"-> NewEnumerationCreationWizardPage.setSpecificValues(itype, importsmanager, iprogressmonitor, map)");
			// Does nothing
	}
}
