package com.aston.wizards.designpattern;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewCreationWizard;
import com.aston.utils.Utils;

/**
 * This is a factory creation Wizard.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>

 * @version 1.0
 */
public class NewFactoryCreationWizard extends NewCreationWizard {
	/** The only wizard page. */ 
	private NewFactoryCreationWizardPage fPage;

	/**
	 * Constructor of the object. 
	 */
	public NewFactoryCreationWizard() {
		super();
		LogMessage.getInstance().log(
				"-> NewFactoryCreationWizard.NewFactoryCreationWizard()");
		setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
		setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
		setWindowTitle(AstonWizardsPlugin.getResourceString("lg.label.createfact"));
	}

	/**
	 * Adds pages to the wizard. 
	 */
	public void addPages() {
		LogMessage.getInstance().log("-> NewFactoryCreationWizard.addPages()");
		super.addPages();
		this.fPage = new NewFactoryCreationWizardPage();
		addPage(this.fPage);
		this.fPage.init(getSelection());
	}

	/**
	 * Is calls when wizard is about to finish. 
	 * 
	 * @return true when it has finished
	 */
	public boolean performFinish() {
		LogMessage.getInstance().log(
				"-> NewFactoryCreationWizard.performFinish()");
		try {
			if (finishPage(this.fPage.getRunnable())) {
				ICompilationUnit cu =
					this.fPage.getCreatedType().getCompilationUnit();
//				if (cu.isWorkingCopy()) {
//					cu = (ICompilationUnit) cu.getOriginalElement();
//				}
				IResource resource = cu.getUnderlyingResource();
				selectAndReveal(resource);
				openResource(resource);
				return true;
			}
		} catch (Exception e) {
			Utils.showError(e, getShell());
		}
		return false;
	}
}
