package com.aston.wizards.designpattern;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.internal.compiler.env.IConstants;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewTypeContainerWizardPage;

/**
 * Wizard page to create a new Factory class. <p>
 * 
 * A Factory class is a singleton that handles a Map of object.
 * 
 * This class is inspired of the org.eclipse.jdt.ui.wizards.NewClassWizardPage.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */
public class NewFactoryCreationWizardPage extends NewTypeContainerWizardPage {
 
	protected final static String SETTINGS_CREATE_PUT = "create_put";

	/**
	 * Constructor of the object. 
	 */
	public NewFactoryCreationWizardPage() {
		super(true, "NewFactoryCreationWizardPage", "factory");
		LogMessage
				.getInstance()
				.log(
						"-> NewFactoryCreationWizardPage.NewFactoryCreationWizardPage()");
	}

	protected void initThePage() {
		LogMessage.getInstance().log(
				"-> NewFactoryCreationWizardPage.initThePage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.factorywizard"));
		setDescription(
			AstonWizardsPlugin.getResourceString("lg.label.willgeneratefactory"));

		TypeFieldsAdapter adapter = new TypeFieldsAdapter();
		adapter.setJavaSearchConstants(IJavaSearchConstants.CLASS);
		adapter.setDialogTitle(
			AstonWizardsPlugin.getResourceString("lg.label.choosecontained"));
		adapter.setDialogMessage(
			AstonWizardsPlugin.getResourceString("lg.label.selectcontained"));

		this.fContainedClassDialogField = new StringButtonDialogField(adapter);
		this.fContainedClassDialogField.setDialogFieldListener(adapter);
		this.fContainedClassDialogField.setButtonLabel(
			AstonWizardsPlugin.getResourceString("lg.label.select"));
		this.fContainedClassDialogField.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.facthandle"));
		String[] buttonNames3 =
			new String[] {
				AstonWizardsPlugin.getResourceString("lg.label.createim"),
				AstonWizardsPlugin.getResourceString("lg.label.createmain"),
				AstonWizardsPlugin.getResourceString("lg.label.createc"),
				AstonWizardsPlugin.getResourceString("lg.label.createput")};
		this.fMethodStubsButtons =
			new SelectionButtonDialogFieldGroup(SWT.CHECK, buttonNames3, 2);
		// You must specify the visibility also
		setModifiers(IConstants.AccFinal | IConstants.AccPublic, true);
	}

	/**
	 * The wizard owning this page is responsible for calling this method 
	 * with the current selection. The selection is used to 
	 * initialize the fields of the wizard page.
	 * 
	 * @param selection used to initialize the fields
	 */
	public void init(IStructuredSelection selection) {
		LogMessage.getInstance().log(
				"-> NewFactoryCreationWizardPage.init(selection)");
		IJavaElement jelem = getInitialJavaElement(selection);
		initContainerPage(jelem);
		initTypePage(jelem);
		doStatusUpdate();

		boolean[] values = new boolean[4];
		values[2] = true;

		IDialogSettings section =
			getDialogSettings().getSection(this.getName());
		if (section != null) {
			values[0] = section.getBoolean(SETTINGS_CREATE_INHERITED);
			values[1] = section.getBoolean(SETTINGS_CREATE_MAIN);
			values[2] = section.getBoolean(SETTINGS_CREATE_CONSTR);
			values[3] = section.getBoolean(SETTINGS_CREATE_PUT);
		}
		setMethodStubSelection(values, true);
	}

	protected void updateSectionValues() {
		LogMessage.getInstance().log(
				"-> NewFactoryCreationWizardPage.updateSectionValues()");
		super.updateSectionValues();
		IDialogSettings section =
			getDialogSettings().getSection(this.getName());
		section.put(SETTINGS_CREATE_PUT, isCreatePut());
	}

	/**
	 * Returns the current selection state of the 'Create put' abstract 
	 * methods checkbox.
	 * 
	 * @return the selection state of the 'Create put' abstract methods
	 * checkbox
	 */
	public boolean isCreatePut() {
		LogMessage.getInstance().log(
				"-> NewFactoryCreationWizardPage.isCreatePut()");
		return this.fMethodStubsButtons.isSelected(3);
	}

	/**
	 * Builds the methods for the given type.
	 * 
	 * @param file the String loaded from the template file
	 * @param type the created type
	 * @param imports object used for importing classes
	 * @param monitor the monitor used during the process
	 * 
	 * @throws CoreException if a problem occured
	 */
	protected void createMethods(
		String file,
		IType type,
		ImportsManager imports,
		IProgressMonitor monitor)
		throws CoreException {
		LogMessage
				.getInstance()
				.log(
						"-> NewFactoryCreationWizardPage.createMethods(file, type, imports, monitor)");
		Map m = loadXmlParts(file, MARK_METHOD, TOKEN_NAME);
		boolean doPut = isCreatePut();
		Iterator it = m.keySet().iterator();
		while (it.hasNext()) {
			String key = (String) it.next();
			String body = (String) m.get(key);
			if (!doPut && "put".equals(key)) {
				continue;
			}
			type.createMethod(body, null, false, monitor);
			body = null;
			key = null;
		}
		it = null;
		m.clear();
		m = null;
	}
}