package com.aston.wizards.designpattern;

import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.utils.Utils;

/**
 * Wizard page to create a new Array class. <p>
 * 
 * This class is inspired of the org.eclipse.jdt.ui.wizards.NewClassWizardPage.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */
public class NewMapCreationWizardPage
	extends com.aston.NewTypeDoubleContainerWizardPage {
 

	protected final static String SETTINGS_MAP = "map";
	protected ComboDialogField mapType;

	/**
	 * Constructor of the object.
	 * 
	 * @param isClass <code>true</code> if a new class is to be created; otherwise
	 * an interface is to be created
	 * @param pageName the wizard page's name
	 */
	protected NewMapCreationWizardPage() {
		super(true, "NewMapCreationWizardPage", "map");
		LogMessage.getInstance().log(
				"-> NewMapCreationWizardPage.NewMapCreationWizardPage()");
	}

	/**
	 * Updates status. 
	 */
	protected void doStatusUpdate() {
		LogMessage.getInstance().log(
				"-> NewMapCreationWizardPage.doStatusUpdate()");
		super.doStatusUpdate();

		String aMapType = null;
		if (this.mapType != null) {
			aMapType = this.mapType.getText().trim();
		}

		// Cannot use Weak with basic key	
		if (getSecondContainedClassName() != null
			&& Utils.isBasicType(getSecondContainedClassName().trim())
			&& ((String) Utils.MAP_CLASS.get(2)).equals(aMapType)) {
			setErrorMessage(AstonWizardsPlugin.getResourceString("lg.warning.weakhm"));
			setPageComplete(false);
			return;
		}

		if ("".equals(aMapType)) {
			setErrorMessage(AstonWizardsPlugin.getResourceString("lg.warning.mapmbs"));
			setPageComplete(false);
			return;
		}
	}

	/**
	 * Updates status when a field changes.
	 * 
	 * @param fieldName the name of the field that had change
	 */
	protected void handleFieldChanged(String fieldName) {
		LogMessage.getInstance().log(
				"-> NewMapCreationWizardPage.handleFieldChanged(fieldName)");
		super.handleFieldChanged(fieldName);

		doStatusUpdate();
	}

	/**
	 * Creates the window that will represent the wizard page. 
	 * 
	 * @param parent the parent of this page
	 */
	public void createControl(Composite parent) {
		LogMessage.getInstance().log(
				"-> NewMapCreationWizardPage.createControl(parent)");
		initializeDialogUnits(parent);

		Composite composite = new Composite(parent, SWT.NONE);

		int nColumns = 4;

		GridLayout layout = new GridLayout();
		layout.numColumns = nColumns;
		composite.setLayout(layout);

		// pick & choose the wanted UI components

		createContainerControls(composite, nColumns);
		createPackageControls(composite, nColumns);
		createEnclosingTypeControls(composite, nColumns);

		createSeparator(composite, nColumns);

		createTypeNameControls(composite, nColumns);
		createModifierControls(composite, nColumns);

		createSuperClassControls(composite, nColumns);

		createContainedClassControls(composite, nColumns);
		createContainedSecondClassControls(composite, nColumns);

		createSuperInterfacesControls(composite, nColumns);

		createControlForTemplate(composite, nColumns);

		this.mapType = new ComboDialogField(SWT.BORDER | SWT.SINGLE);
		this.mapType.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.maptouse"));
		this.mapType.setItems(Utils.asStringArray(Utils.MAP_CLASS));
		this.mapType.selectItem(0);
		this.mapType.doFillIntoGrid(composite, nColumns);
		this.mapType.setDialogFieldListener(this);
		createMethodStubSelectionControls(composite, nColumns);

		createMethodStubSelectionControls(composite, nColumns);

		setControl(composite);
	}

	/**
	 * Adds specfic values to the Map of keys.
	 * 
	 * @param type type of the object
	 * @param imports the imports of the file
	 * @param monitor the progress bar
	 * @param values the current Map that contains values for the template
	 */
	protected void setSpecificValues(
		IType type,
		ImportsManager imports,
		IProgressMonitor monitor,
		Map values) {
		LogMessage
				.getInstance()
				.log(
						"-> NewMapCreationWizardPage.setSpecificValues(type, imports, monitor, values)");
		super.setSpecificValues(type, imports, monitor, values);
		values.put(MARK_MAP_TYPE, getMapClassName());
	}

	/**
	 * Returns the Map class name.
	 * 
	 * @return the Map clas sname
	 */
	public String getMapClassName() {
		LogMessage.getInstance().log(
				"-> NewMapCreationWizardPage.getMapClassName()");
		return this.mapType.getText();
	}

	/**
	 * @see com.aston.NewTypeWizardPage#initThePage()
	 */
	protected void initThePage() {
		LogMessage.getInstance().log(
				"-> NewMapCreationWizardPage.initThePage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.mapwizard"));
		setDescription(AstonWizardsPlugin.getResourceString("lg.label.mapwillgen"));

		String[] buttonNames3 =
			new String[] {
				AstonWizardsPlugin.getResourceString("lg.label.createim"),
				AstonWizardsPlugin.getResourceString("lg.label.createmain"),
				AstonWizardsPlugin.getResourceString("lg.label.createc")};
		this.fMethodStubsButtons =
			new SelectionButtonDialogFieldGroup(SWT.CHECK, buttonNames3, 2);
		this.fMethodStubsButtons.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.options"));

		TypeFieldsAdapter adapter = new TypeFieldsAdapter();
		adapter.setDialogTitle(
			AstonWizardsPlugin.getResourceString("lg.label.choosecontained"));
		adapter.setDialogMessage(
			AstonWizardsPlugin.getResourceString("lg.label.selectcontained"));

		this.fContainedClassDialogField = new StringButtonDialogField(adapter);
		this.fContainedClassDialogField.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.mapvalue"));
		this.fContainedClassDialogField.setButtonLabel(
			AstonWizardsPlugin.getResourceString("lg.label.select"));

		TypeFieldsAdapter adapter2 = new TypeFieldsAdapter();
		this.fSecondContainedClassDialogField =
			new StringButtonDialogField(adapter2);
		this.fSecondContainedClassDialogField.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.mapkey"));
		this.fSecondContainedClassDialogField.setButtonLabel(
			AstonWizardsPlugin.getResourceString("lg.label.select"));
		adapter2.setDialogTitle(
			AstonWizardsPlugin.getResourceString("lg.label.choosecontainedkey"));
		adapter2.setDialogMessage(
			AstonWizardsPlugin.getResourceString("lg.label.selectcontainedkey"));

		this.fContainedClassDialogField.setDialogFieldListener(adapter);
		this.fSecondContainedClassDialogField.setDialogFieldListener(adapter2);
		
	}

	/**
	 * Memorize the selected options. <br>
	 */
	protected void updateSectionValues() {
		LogMessage.getInstance().log(
				"-> NewMapCreationWizardPage.updateSectionValues()");
		super.updateSectionValues();
		IDialogSettings section =
			getDialogSettings().getSection(this.getName());
		section.put(SETTINGS_MAP, this.mapType.getText());
	}

	/**
	 * Sets the "old" value in the window.
	 */
	protected void loadSelectionValues() {
		LogMessage.getInstance().log(
				"-> NewMapCreationWizardPage.loadSelectionValues()");
		super.loadSelectionValues();
		IDialogSettings section =
			getDialogSettings().getSection(this.getName());
		if (section!=null) {			
			String temp = section.get(SETTINGS_MAP);
			
			if (this.mapType!=null &&
				temp!=null && 
				!"".equals(temp)) {	
				this.mapType.setText(temp);
			}
		}		
	}

}