package com.aston.wizards.designpattern;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.swt.SWT;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;

/**
 * Wizard page to create a new Singleton class. <p>
 * 
 * This class is inspired of the org.eclipse.jdt.ui.wizards.NewClassWizardPage.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */
public class NewObjectCreationWizardPage extends com.aston.NewTypeWizardPage {
 
	/**
	 * Constructor of the object. 
	 */
	public NewObjectCreationWizardPage() {
		super(true, "NewObjectCreationWizardPage", "object");
		LogMessage.getInstance().log(
				"-> NewObjectCreationWizardPage.NewObjectCreationWizardPage()");
	}

	protected void initThePage() {
		LogMessage.getInstance().log(
				"-> NewObjectCreationWizardPage.initThePage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.objwizard"));
		setDescription(AstonWizardsPlugin.getResourceString("lg.label.objwillgen"));
		String[] buttonNames3 =
			new String[] {
				AstonWizardsPlugin.getResourceString("lg.label.createim"),
				AstonWizardsPlugin.getResourceString("lg.label.createmain"),
				AstonWizardsPlugin.getResourceString("lg.label.createc")};
		this.fMethodStubsButtons =
			new SelectionButtonDialogFieldGroup(SWT.CHECK, buttonNames3, 2);
		this.fMethodStubsButtons.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.options"));
	}

	/**
	 * Adds specfic values to the Map of keys.
	 * 
	 * @param type type of the object
	 * @param imports the imports of the file
	 * @param monitor the progress bar
	 * @param values the current Map that contains values for the template
	 */
	protected void setSpecificValues(
		IType type,
		ImportsManager imports,
		IProgressMonitor monitor,
		Map values) {
		LogMessage
				.getInstance()
				.log(
						"-> NewObjectCreationWizardPage.setSpecificValues(type, imports, monitor, values)");
		// Does nothing
	}

}