package com.aston.wizards.designpattern;

import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.swt.widgets.Composite;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.utils.Utils;

/**
 * Wizard page to create a new List class. <p>
 * 
 * A List class is a dynamic array of object, its size can change.
 * 
 * This class is inspired of the org.eclipse.jdt.ui.wizards.NewClassWizardPage.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */
public class NewSetCreationWizardPage extends NewListCreationWizardPage {
 
	/**
	 * Constructor of the object. 
	 */
	public NewSetCreationWizardPage() {
		super(true, "NewSetCreationWizardPage", "set");
		LogMessage.getInstance().log(
				"-> NewSetCreationWizardPage.NewSetCreationWizardPage()");
	}

	protected void initThePage() {
		LogMessage.getInstance().log(
				"-> NewSetCreationWizardPage.initThePage()");
		super.initThePage();
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.setwizard"));
		setDescription(AstonWizardsPlugin.getResourceString("lg.label.setwillgen"));
		this.fContainedClassDialogField.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.setcontainsonly"));
	}

	/**
	 * Creates the label for the template list.
	 * 
	 * @param composite the parent
	 * @param nColumns the number of columns
	 */
	protected void createControlForTemplate(
		Composite composite,
		int nColumns) {
		LogMessage
				.getInstance()
				.log(
						"-> NewSetCreationWizardPage.createControlForTemplate(composite, nColumns)");
		super.createControlForTemplate(composite, nColumns);

		this.listType.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.settouse"));
		this.listType.setItems(Utils.asStringArray(Utils.SET_CLASS));
		this.listType.selectItem(0);
		this.listType.doFillIntoGrid(composite, nColumns);
		this.listType.setDialogFieldListener(this);

		createMethodStubSelectionControls(composite, nColumns);

		setControl(composite);
	}

	/**
	 * Updates status. 
	 */
	protected void doStatusUpdate() {
		LogMessage.getInstance().log(
				"-> NewSetCreationWizardPage.doStatusUpdate()");
		super.doStatusUpdate();
		if (this.listType != null) {
			if ("".equals(this.listType.getText().trim())) {
				setErrorMessage(
					AstonWizardsPlugin.getResourceString("lg.warning.setmbspec"));
				setPageComplete(false);
				return;
			}
		}
	}

	/**
	 * Adds specfic values to the Map of keys.
	 * 
	 * @param type type of the object
	 * @param imports the imports of the file
	 * @param monitor the progress bar
	 * @param values the current Map that contains values for the template
	 */
	protected void setSpecificValues(
		IType type,
		ImportsManager imports,
		IProgressMonitor monitor,
		Map values) {
		LogMessage
				.getInstance()
				.log(
						"-> NewSetCreationWizardPage.setSpecificValues(type, imports, monitor, values)");
		super.setSpecificValues(type, imports, monitor, values);
		values.put(MARK_SET_TYPE, super.getListClassName());
	}
}