/*
 * Copyright (c) 1997-2002 Genuitec, LLC.
 * All rights reserved.
 */
package com.aston.wizards.ejb;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewCreationWizard;
import com.aston.utils.Utils;

/**
 * This is an EJB creation Wizard.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a>
 * contributed by Genuitec, LLC <br>
 * 
 * @author Genuitec, LLC
 */
public class NewEjbCreationWizard extends NewCreationWizard {
 
	private static ImageDescriptor wizardPageImageDesc;
	static {
		try {
			URL installURL = 
				AstonWizardsPlugin.getDefault().getBundle().getEntry("/");
			URL url = new URL(installURL, "icons/genuitec_ico.gif"); //$NON-NLS-1$
			wizardPageImageDesc = ImageDescriptor.createFromURL(url);
		} catch (MalformedURLException e) {
			// Should not happen.  Ignore.
		}
	}

	/** The only wizard page. */
	private NewEjbCreationWizardPage fPage;

	/**
	 * Constructor of the object. 
	 */
	public NewEjbCreationWizard() {
		super();
		LogMessage.getInstance().log(
				"-> NewEjbCreationWizard.NewEjbCreationWizard()");
		setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
		setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
		setWindowTitle(AstonWizardsPlugin.getResourceString("lg.label.createejb"));
	}

	/**
	 * Adds pages to the wizard. 
	 */
	public void addPages() {
		LogMessage.getInstance().log("-> NewEjbCreationWizard.addPages()");
		this.fPage = new NewEjbCreationWizardPage();

		addPage(this.fPage);
		this.fPage.init(getSelection());
	}

	/**
	 * Is calls when wizard is about to finish. 
	 * 
	 * @return true when it has finished
	 */
	public boolean performFinish() {
		LogMessage.getInstance().log("-> NewEjbCreationWizard.performFinish()");
		try {
			boolean taskValue = finishPage(this.fPage.getRunnable());
			if (taskValue) {
				ICompilationUnit cu =
					this.fPage.getCreatedType().getCompilationUnit();
//				if (cu.isWorkingCopy()) {
//					cu = (ICompilationUnit) cu.getOriginalElement();
//				}
				IResource resource = cu.getUnderlyingResource();
				selectAndReveal(resource);
				openResource(resource);
				return true;
			}
		} catch (Exception e) {
			Utils.showError(e, getShell());
		}
		return false;
	}

	// TODO: TEW Fix - add icon
	protected void initializeDefaultPageImageDescriptor() {
		LogMessage
				.getInstance()
				.log(
						"-> NewEjbCreationWizard.initializeDefaultPageImageDescriptor()");
		setDefaultPageImageDescriptor(wizardPageImageDesc);
	}
}
