package com.aston.wizards.html;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewCreationWizard;
import com.aston.utils.Utils;

/**
 * This is a Html creation Wizard.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>

 * @version 1.0
 */
public class NewHtmlCreationWizard extends NewCreationWizard {
	/** The only wizard page. */
	private NewHtmlCreationWizardPage fPage;
 
	/**
	 * Constructor of the object. 
	 */
	public NewHtmlCreationWizard() {
		super();
		LogMessage.getInstance().log(
				"-> NewHtmlCreationWizard.NewHtmlCreationWizard()");
		setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
		setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
		setWindowTitle(AstonWizardsPlugin.getResourceString("lg.label.createhtml"));
	}

	/**
	 * Adds pages to the wizard. 
	 */
	public void addPages() {
		LogMessage.getInstance().log("-> NewHtmlCreationWizard.addPages()");
		this.fPage = new NewHtmlCreationWizardPage();
		addPage(this.fPage);
		this.fPage.init(getSelection());
	}

	/**
	* Is calls when wizard is about to finish. 
	* 
	* @return true when it has finished
	*/
	public boolean performFinish() {
		LogMessage.getInstance()
				.log("-> NewHtmlCreationWizard.performFinish()");
		try {
			return finishPage(this.fPage.getRunnable());
		} catch (Exception e) {
			Utils.showError(e, getShell());
		}
		return false;
	}
}
