package com.aston.wizards.html;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.utils.Utils;

/**
 * Wizard page to create a new Html file. <p>
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */
public class NewHtmlCreationWizardPage extends com.aston.WizardPage {
	protected final static String SETTINGS_DOCTYPE = "doctype";

	private ComboDialogField fileDoctype;

	private Button button;
 
	/**
	 * Constructor of the object.
	 */
	public NewHtmlCreationWizardPage() {
		super("NewHtmlCreationWizardPage", "html");
		LogMessage.getInstance().log(
				"-> NewHtmlCreationWizardPage.NewHtmlCreationWizardPage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.htmlwiz"));
		setDescription(AstonWizardsPlugin.getResourceString("lg.label.htmlwillgen"));
	}

	/**
	 * Sets the "old" value in the window.
	 */
	protected void loadSectionValues() {
		LogMessage.getInstance().log(
				"-> NewHtmlCreationWizardPage.loadSectionValues()");
		super.loadSectionValues();
		IDialogSettings section =
			getDialogSettings().getSection(this.getName());
			
		if (section != null) {
			String doc = section.get(SETTINGS_DOCTYPE);
			if (this.fileDoctype != null && doc != null && !"".equals(doc)) {
				this.fileDoctype.setText(doc);
			}
		}
	}

	/**
	 * Memorize the selected options. <br>
	 */
	protected void updateSectionValues() {
		LogMessage.getInstance().log(
				"-> NewHtmlCreationWizardPage.updateSectionValues()");
		super.updateSectionValues();
		IDialogSettings section =
			getDialogSettings().getSection(this.getName());
		section.put(SETTINGS_DOCTYPE, this.fileDoctype.getText());
	}

	/**
	 * Create a control for this page.
	 * 
	 * @param parent the parent of this control
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		LogMessage.getInstance().log(
				"-> NewHtmlCreationWizardPage.createControl(parent)");
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 2;

		ModifyListener ml = new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				NewHtmlCreationWizardPage.this.dialogChanged();
			}
		};

		Label label = new Label(composite, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.filepath"));
		this.filePathText = new Text(composite, SWT.BORDER | SWT.SINGLE);
		this.filePathText.setText(getGlobalPath());
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		this.filePathText.setLayoutData(gd);
		this.filePathText.addModifyListener(ml);
		this.button = new Button(composite, SWT.PUSH);
		this.button.setText(AstonWizardsPlugin.getResourceString("lg.label.browse"));
		this.button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				NewHtmlCreationWizardPage.this.handleBrowse();
			}
		});

		// File Name
		label = new Label(composite, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.filename"));
		this.fileNameText = new Text(composite, SWT.BORDER | SWT.SINGLE);
		this.fileNameText.setText("MyHtml.html");
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.fileNameText.setLayoutData(gd);
		this.fileNameText.addModifyListener(ml);
		label = new Label(composite, SWT.NULL);

		this.fileDoctype =
			new ComboDialogField(SWT.READ_ONLY | SWT.BORDER | SWT.SINGLE);

		List l = Utils.DOCTYPE_VALUES;
		String[] tab = new String[l.size()];
		int i = 0;
		Iterator it = l.iterator();
		while (it.hasNext()) {
			tab[i] = (String) it.next();
			i++;
		}
		this.fileDoctype.setItems(tab);
		this.fileDoctype.selectItem(0);
		this.fileDoctype.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.doctype"));
		this.fileDoctype.doFillIntoGrid(composite, layout.numColumns);
		this.fileDoctype.setDialogFieldListener(this);

		createControlForTemplate(composite, layout.numColumns);

		dialogChanged();
		setControl(composite);
	}

	/**
	 * Returns the doctype for this file
	 * 
	 * @return the doctype for this file
	 */
	public String getDoctype() {
		LogMessage.getInstance().log(
				"-> NewHtmlCreationWizardPage.getDoctype()");
		return this.fileDoctype.getText();
	}

	/**
	 * Returns the runnable that creates the type using the current settings.
	 * The returned runnable must be executed in the UI thread.
	 * 
	 * @return the runnable to create the new type
	 */
	public IRunnableWithProgress getRunnable() {
		LogMessage.getInstance().log(
				"-> NewHtmlCreationWizardPage.getRunnable()");
		Map values = new HashMap(4);
		values.put(MARK_FILE_NAME, getFileName());
		values.put(MARK_FILE_PATH, getFilePath());
		values.put(MARK_HTML_DOCTYPE, getDoctype());
		values.put(MARK_HTML_TITLE, getFileName());
		values.put(MARK_TEMPLATE_NAME, getTemplateFileName());

		return new AstonRunnableWithProgress(values, this);
	}

	protected void dialogChanged() {
		LogMessage.getInstance().log(
				"-> NewHtmlCreationWizardPage.dialogChanged()");
		super.dialogChanged();
		if (isPageComplete()) {
			String fileName = getFileName();
			if (!fileName.toLowerCase().endsWith(".html")
				&& !fileName.toLowerCase().endsWith(".htm")) {
				setErrorMessage(
					AstonWizardsPlugin.getResourceString("lg.warning.htmlfilemustbe"));
				setPageComplete(false);
				return;
			}
		}
	}
}