package com.aston.wizards.jsp;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewCreationWizard;
import com.aston.utils.Utils;
import com.aston.wizards.servlet.NewWebXmlLinkCreationWizardPage;

/**
 * This is a JSP creation Wizard.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>

 * @version 1.0
 */
public class NewJspCreationWizard extends NewCreationWizard {
	/** The only wizard page. */
	private NewJspCreationWizardPage fPage;
	private NewWebXmlLinkCreationWizardPage fPageWebXml;
 
	/**
	 * Constructor of the object. 
	 */
	public NewJspCreationWizard() {
		super();
		LogMessage.getInstance().log(
				"-> NewJspCreationWizard.NewJspCreationWizard()");
		setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
		setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
		setWindowTitle(AstonWizardsPlugin.getResourceString("lg.label.createjsp"));
	}

	/**
	 * Adds pages to the wizard. 
	 */
	public void addPages() {
		LogMessage.getInstance().log("-> NewJspCreationWizard.addPages()");
		this.fPage = new NewJspCreationWizardPage();
		this.fPageWebXml = new NewWebXmlLinkCreationWizardPage();
		addPage(this.fPage);
		addPage(this.fPageWebXml);
		this.fPageWebXml.setPreviousPage(this.fPage);
		this.fPage.init(getSelection());
		this.fPageWebXml.init(getSelection());
	}

	/**
	 * Is calls when wizard is about to finish. 
	 * 
	 * @return true when it has finished
	 */
	public boolean performFinish() {
		LogMessage.getInstance().log("-> NewJspCreationWizard.performFinish()");
		try {
			boolean p1 = finishPage(this.fPageWebXml.getRunnable());
			boolean p2 = finishPage(this.fPage.getRunnable());
			return p1 && p2;
		} catch (Exception e) {
			Utils.showError(e, getShell());
		}
		return false;
	}
}
