package com.aston.wizards.jsp;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;

/**
 * Wizard page to create a new Jsp file. <p>
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */
public class NewJspCreationWizardPage extends com.aston.WizardPage {

	private Button button;
 
	/**
	 * Constructor for the object.
	 */
	public NewJspCreationWizardPage() {
		super("NewJspCreationWizardPage", "jsp");
		LogMessage.getInstance().log(
				"-> NewJspCreationWizardPage.NewJspCreationWizardPage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.jspwiz"));
		setDescription(AstonWizardsPlugin.getResourceString("lg.label.willjspgen"));
	}

	/**
	 * Create a control for this page.
	 * 
	 * @param parent the parent of this control
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		LogMessage.getInstance().log(
				"-> NewJspCreationWizardPage.createControl(parent)");
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 2;

		Label label = new Label(composite, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.filepath"));
		this.filePathText = new Text(composite, SWT.BORDER | SWT.SINGLE);
		this.filePathText.setText(getGlobalPath());
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		this.filePathText.setLayoutData(gd);
		this.filePathText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});
		this.button = new Button(composite, SWT.PUSH);
		this.button.setText(AstonWizardsPlugin.getResourceString("lg.label.browse"));
		this.button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				NewJspCreationWizardPage.this.handleBrowse();
			}
		});

		// File Name
		label = new Label(composite, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.filename"));
		this.fileNameText = new Text(composite, SWT.BORDER | SWT.SINGLE);
		this.fileNameText.setText("MyJsp.jsp");
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.fileNameText.setLayoutData(gd);
		this.fileNameText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				NewJspCreationWizardPage.this.dialogChanged();
			}
		});
		label = new Label(composite, SWT.NULL);

		createControlForTemplate(composite, layout.numColumns);
		label = new Label(composite, SWT.NULL);

		setControl(composite);
		//		dialogChanged();		
	}

	/**
	 * Ensures that both text fields are set.
	 */
	protected void dialogChanged() {
		LogMessage.getInstance().log(
				"-> NewJspCreationWizardPage.dialogChanged()");
		super.dialogChanged();
		if (isPageComplete()) {
			String fileName = getFileName();
			if (!fileName.toLowerCase().endsWith(".jsp")) {
				setErrorMessage(
					AstonWizardsPlugin.getResourceString("lg.warning.filemustjsp"));
				setPageComplete(false);
				return;
			}
		}
	}

	/**
	 * Returns the runnable that creates the type using the current settings.
	 * The returned runnable must be executed in the UI thread.
	 * 
	 * @return the runnable to create the new type
	 */
	public IRunnableWithProgress getRunnable() {
		LogMessage.getInstance().log(
				"-> NewJspCreationWizardPage.getRunnable()");
		final Map values = new HashMap(4);
		values.put(MARK_FILE_NAME, getFileName());
		values.put(MARK_FILE_PATH, getFilePath());
		values.put(MARK_TEMPLATE_NAME, getTemplateFileName());
		values.put(MARK_HTML_TITLE, getFileName());

		return new AstonRunnableWithProgress(values, this);
	}
}