package com.aston.wizards.servlet;

import org.eclipse.jdt.core.JavaModelException;

import com.aston.AstonWizardsPlugin;
import com.aston.BasicMethodActionICompilationUnit;
import com.aston.LogMessage;
import com.aston.wizards.xml.*;

/**
 * Map and declare a servlet in the web.xml file.
 * 
 * @author 
 * <ul>
 * 	<li><a href="renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version V1.0
 */
public class MenuActionMapServlet extends BasicMethodActionICompilationUnit {
 
	/**
	 * Constructor for MethodToString.
	 */
	public MenuActionMapServlet() {
		super();
		LogMessage.getInstance().log(
				"-> MenuActionMapServlet.MenuActionMapServlet()");
	}

	/**
	 * Indicates if the class is a servlet.
	 * 
	 * Only works for first heritage.
	 * 
	 * @return true if selected class is a DIRECT servlet child
	 */
	protected boolean isServlet() {
		LogMessage.getInstance().log("-> MenuActionMapServlet.isServlet()");
		try {		
			return "HttpServlet".equals(this.selectedClass.getSuperclassName());
		} catch (JavaModelException e) {
			return false;
		}
	}

	/** 
	 * Popup the selection window and map the servlet
	 */
	protected void doAction() {
		LogMessage.getInstance().log("-> MenuActionMapServlet.doAction()");
		WebXmlMappingDialog dt = new WebXmlMappingDialog(AstonWizardsPlugin.getDefault().getShell());
		dt.setTitle(AstonWizardsPlugin.getResourceString("lg.label.mapservlet"));
		dt.create();
		dt.setBasicMethodActionServlet(this);		
		dt.open();
	}

}
