package com.aston.wizards.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.utils.Utils;
import com.aston.wizards.jsp.NewJspCreationWizardPage;

/**
 * Wizard page to create a new web.xml page for your servlet/jsp class/page. <p>
 * 
 * This class is inspired of the org.eclipse.jdt.ui.wizards.NewClassWizardPage.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */
public class NewWebXmlLinkCreationWizardPage extends com.aston.WizardPage {
 
	private final static String GENERATE_XML = "generateXml";

	protected final static String SETTINGS_DESCRIPTION = "description";
	protected final static String SETTINGS_DISPLAY_NAME = "display_name";
	protected final static String SETTINGS_DO_MAPPING = "do_mapping";

	private Text nameText;
	private Text classNameText;
	private Text mappingNameText;

	private Text displayNameText;
	private Text descriptionText;

	private Button button;

	/**
	 * Constructor for NewAppletHtmlCreationWizardPage.
	 */
	public NewWebXmlLinkCreationWizardPage() {
		super("NewWebXmlLinkCreationWizardPage", null);
		LogMessage
				.getInstance()
				.log(
						"-> NewWebXmlLinkCreationWizardPage.NewWebXmlLinkCreationWizardPage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.xmlwiz"));
		setDescription(AstonWizardsPlugin.getResourceString("lg.label.xmllinkwillgen"));
	}

	/**
	 * Memorize the selected options. <br>
	 */
	protected void updateSectionValues() {
		LogMessage.getInstance().log(
				"-> NewWebXmlLinkCreationWizardPage.updateSectionValues()");
		super.updateSectionValues();
		IDialogSettings section =
			getDialogSettings().getSection(this.getName());
		if (section == null) {
			section = getDialogSettings().addNewSection(this.getName());
		}
		section.put(SETTINGS_DESCRIPTION, this.descriptionText.getText());
		section.put(SETTINGS_DISPLAY_NAME, this.displayNameText.getText());
		section.put(SETTINGS_DO_MAPPING, this.generateBool.getBooleanValue());
	}
	
	

	/**
	 * Create a control for this page.
	 * 
	 * @param parent the parent of this control
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		LogMessage.getInstance().log(
				"-> NewWebXmlLinkCreationWizardPage.createControl(parent)");
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;

		Composite c = new Composite(container, SWT.NULL);

		this.generateBool =
			new BooleanFieldEditor(
				GENERATE_XML,
				AstonWizardsPlugin.getResourceString("lg.label.xmlgen"),
				c);
		PreferenceStore ps = new PreferenceStore();
		ps.setValue(GENERATE_XML, true);
		this.generateBool.setPreferenceStore(ps);
		this.generateBool.load();
		this.generateBool.setPropertyChangeListener(new IPropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent e) {
				NewWebXmlLinkCreationWizardPage.this.generateBoolUpdate();
			}
		});
		Label label = new Label(container, SWT.NULL);
		label = new Label(container, SWT.NULL);

		label = new Label(container, SWT.NULL);
		label = new Label(container, SWT.NULL);
		label = new Label(container, SWT.NULL);

		ModifyListener ml = new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				NewWebXmlLinkCreationWizardPage.this.dialogChanged();
			}
		};

		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.classename"));
		this.classNameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		this.classNameText.setEditable(false);
		this.classNameText.setEnabled(false);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		this.classNameText.setLayoutData(gd);
		label = new Label(container, SWT.NULL);

		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.jspname"));
		this.nameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.nameText.setLayoutData(gd);
		this.nameText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.urlname"));
		this.mappingNameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.mappingNameText.setLayoutData(gd);
		this.mappingNameText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.xmlfilepath"));
		this.filePathText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.filePathText.setLayoutData(gd);
		this.filePathText.addModifyListener(ml);
		this.button = new Button(container, SWT.PUSH);
		this.button.setText(AstonWizardsPlugin.getResourceString("lg.label.browse"));
		this.button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				NewWebXmlLinkCreationWizardPage.this.handleBrowse();
			}
		});

		// File Name
		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.displayname"));
		this.displayNameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.displayNameText.setLayoutData(gd);
		this.displayNameText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		// Applet height
		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.description"));
		this.descriptionText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.descriptionText.setLayoutData(gd);
		this.descriptionText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		dialogChanged();
		setControl(container);

	}

	/**
	 * Called when user check (or uncheck) the generate HTML page.
	 */
	public void generateBoolUpdate() {
		LogMessage.getInstance().log(
				"-> NewWebXmlLinkCreationWizardPage.generateBoolUpdate()");
		boolean value = this.generateBool.getBooleanValue();

		this.nameText.setEditable(value);
		this.filePathText.setEditable(value);
		this.mappingNameText.setEditable(value);
		this.displayNameText.setEditable(value);
		this.descriptionText.setEditable(value);

		this.filePathText.setEnabled(value);
		this.mappingNameText.setEnabled(value);
		this.displayNameText.setEnabled(value);
		this.descriptionText.setEnabled(value);
		this.nameText.setEnabled(value);
		this.button.setEnabled(value);
		dialogChanged();
	}

	/**
	 * Sets the "old" value in the window.
	 */
	protected void loadSectionValues() {
		LogMessage.getInstance().log(
				"-> NewWebXmlLinkCreationWizardPage.loadSectionValues()");
		super.loadSectionValues();
		IWizardPage wizard = getPreviousPage();
		if (wizard == null) {
			return;
		}

		// Load preferences
		IPreferenceStore ps = this.generateBool.getPreferenceStore();
		IDialogSettings section =
			getDialogSettings().getSection(this.getName());

		String currentGlobalPath = super.getGlobalPath(); 
		String path = Utils.getProjectPath(currentGlobalPath)+"/WEB-INF";

		String description = "This is the description of my J2EE component";
		String display = "This is the display name of my J2EE component";

		if (section != null) {
			path = section.get(SETTINGS_FILE_PATH);
			description = section.get(SETTINGS_DESCRIPTION);
			display = section.get(SETTINGS_DISPLAY_NAME);
			boolean doMap = section.getBoolean(SETTINGS_DO_MAPPING);

			ps.setValue(GENERATE_XML, doMap);
			this.generateBool.load();
			this.generateBoolUpdate();
		
			// If project name is different then use the new ProjectName
			if (!Utils.getProjectPath(currentGlobalPath).equals(Utils.getProjectPath(path))) {
				int id = path.indexOf("/", 1);
				if (id != -1) {
					path = Utils.getProjectPath(currentGlobalPath).concat(path.substring(id));
				}
			}
		}

		if (wizard instanceof NewServletCreationWizardPage) {
			NewServletCreationWizardPage aNewServletCreationWizardPage =
				(NewServletCreationWizardPage) wizard;
			String pck = aNewServletCreationWizardPage.getPackageText();
			if (!"".equals(pck)) {
				pck += ".";
			}
			if (pck==null) {
				pck = "";
			}
			
			String typeName = aNewServletCreationWizardPage.getTypeName();
			String longName = pck.concat(typeName);
			this.classNameText.setText(longName);
			this.nameText.setText(typeName);
			this.mappingNameText.setText("/servlet/" + longName);
		} else if (wizard instanceof NewJspCreationWizardPage) {
			NewJspCreationWizardPage aNewJspCreationWizardPage = (NewJspCreationWizardPage) wizard;
			String fileName = aNewJspCreationWizardPage.getFileName();
			this.classNameText.setText(
				Utils.getJspPath(aNewJspCreationWizardPage.getFilePath()) + "/" + fileName);
			String name = fileName.substring(0, fileName.indexOf(".jsp"));
			this.nameText.setText(name);
			this.mappingNameText.setText(
				Utils.getJspPath(aNewJspCreationWizardPage.getGlobalPath()) + "/" + fileName);
		}
		this.descriptionText.setText(description);
		this.displayNameText.setText(display);
		this.filePathText.setText(path);
	}

	/**
	 * Ensures that both text fields are set.
	 */
	protected void dialogChanged() {
		LogMessage.getInstance().log(
				"-> NewWebXmlLinkCreationWizardPage.dialogChanged()");
		if (this.generateBool.getBooleanValue()) {
			super.dialogChanged();
			if (isPageComplete()) {
				if (this.mappingNameText.getText().trim().length() == 0) {
					setErrorMessage(
						AstonWizardsPlugin.getResourceString(
							"lg.warning.mapmustbespec"));
					setPageComplete(false);
					return;
				}
				if (this.mappingNameText.getText().trim().indexOf(" ") != -1) {
					setErrorMessage(
						AstonWizardsPlugin.getResourceString("lg.warning.nospace"));
					setPageComplete(false);
					return;
				}

				if (this.nameText.getText().trim().length() == 0) {
					setErrorMessage(
						AstonWizardsPlugin.getResourceString("lg.warning.namemustbe"));
					setPageComplete(false);
					return;
				}
				if (this.nameText.getText().trim().indexOf(" ") != -1) {
					setErrorMessage(
						AstonWizardsPlugin.getResourceString("lg.warning.nospacejsp"));
					setPageComplete(false);
					return;
				}
			}
		} else {
			setPageComplete(true);
			setErrorMessage(null);
		}
	}

	/**
	 * Returns the runnable that creates the type using the current settings.
	 * The returned runnable must be executed in the UI thread.
	 * 
	 * @return the runnable to create the new type
	 */
	public IRunnableWithProgress getRunnable() {
		LogMessage.getInstance().log(
				"-> NewWebXmlLinkCreationWizardPage.getRunnable()");
		Map values = new HashMap(6);
		values.put(MARK_FILE_PATH, this.filePathText.getText());
		values.put(MARK_CLASS_NAME, this.classNameText.getText());
		values.put(MARK_JSP_KEY_NAME, this.nameText.getText());
		values.put(MARK_JSP_MAPPING_URL, this.mappingNameText.getText());
		values.put(MARK_JSP_DISPLAY_NAME, this.displayNameText.getText());
		values.put(MARK_JSP_DESCRIPTION, this.descriptionText.getText());
		return new AstonRunnableWithProgress(values, this);
	}

	/**
	 * The worker method. It will find the container, create the
	 * file if missing or just replace its contents, and open
	 * the editor on the newly created file.
	 * 
	 * @param values contains values entered by user
	 * @param monitor the progress bar
	 * @throws CoreException if a problem occured
	 */
	protected void doFinish(Map values, IProgressMonitor monitor)
		throws CoreException {

		LogMessage.getInstance().log(
				"-> NewWebXmlLinkCreationWizardPage.doFinish(values, monitor)");
		final String fileName = "web.xml";
		this.updateSectionValues();
		if (this.generateBool.getBooleanValue()) {
			// create a sample file
			monitor.beginTask(
				AstonWizardsPlugin.getResourceString("lg.label.creating", fileName),
				2);
			IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
			IPath path = new Path((String) values.get(MARK_FILE_PATH));
			IResource resource = root.findMember(path);

			// Create the folder if it does not exist
			if (resource == null) {
				CoreUtility.createFolder(
					root.getFolder(path),
					true,
					true,
					monitor);
				resource = root.findMember(path);
			}

			IContainer container = (IContainer) resource;
			final IFile file = container.getFile(new Path(fileName));
			InputStream stream = null;
			try {
				if (file.exists()) {
					stream = file.getContents();
					stream =
						fillContentStream(
							stream,
							values,
							AstonWizardsPlugin.getResourceString(
								"lg.error.jspnamepresent",
								(String) values.get(MARK_JSP_KEY_NAME)));
					file.setContents(stream, true, true, monitor);
				} else {
					createContentFile(values, file, monitor);
				}
			} catch (Exception e) {
				// TODO Change
				LogMessage.getInstance().log(e.getMessage());
			} finally {
				//System.out.println("Closing Stream");
				if (stream!=null) {
					try {
						stream.close();				
					} catch (IOException e1) {
						// TODO Change
						LogMessage.getInstance().log(e1.getMessage());
					}
				}
			}
			
			monitor.worked(1);
			monitor.setTaskName(AstonWizardsPlugin.getResourceString("lg.label.open"));
			// Remove this if you do not want to open the file			
			getShell().getDisplay().asyncExec(new Runnable() {
				public void run() {
					NewWebXmlLinkCreationWizardPage.this.openResource(file);
				}
			});
			monitor.worked(1);
		}
	}

	/**
	 * We will initialize file contents with a sample text.
	 *
	 * @param in the input stream 
	 * @param values contains values entered by user 
	 * 
	 * @return the input stream that will be used for the creation of the file
	 */
	public static InputStream fillContentStream(
		InputStream in,
		Map values,
		String errorMessage) {
		LogMessage
				.getInstance()
				.log(
						"-> NewWebXmlLinkCreationWizardPage.fillContentStream(in, values, errorMessage)");
		StringBuffer sb = new StringBuffer(128);
		int c = 0;
		try {
			while ((c = in.read()) != -1) {
				sb.append((char) c);
			}
		} catch (IOException io) {
			throw new RuntimeException(
				AstonWizardsPlugin.getResourceString("lg.error.reading"));
		}
		// Search if mapping and name already exist
		String toSearch =
			"<servlet-name>"
				+ values.get(MARK_JSP_KEY_NAME)
				+ "</servlet-name>";
		int isHere = sb.toString().indexOf(toSearch);
		if (isHere == -1) {
			// If mapping does not exist
			NewWebXmlLinkCreationWizardPage.mapAndNameInWebXml(sb, values);
		} else {
			// If mapping exist
			Utils.showError(errorMessage);
		}
		return new ByteArrayInputStream(sb.toString().getBytes());
	}

	/**
	 * We will initialize file contents with a sample text.
	 * 
	 * @param values contains values entered by user
	 * @param file the file where to write
	 * @param monitor the progress bar
	 * 
	 * @throws CoreException if a problem occured  
	 */
	public static void createContentFile(
		Map values,
		IFile file,
		IProgressMonitor monitor)
		throws CoreException {
		LogMessage
				.getInstance()
				.log(
						"-> NewWebXmlLinkCreationWizardPage.createContentFile(values, file, monitor)");
		// TODO I should use a DOM XML tool.

		StringBuffer sb = new StringBuffer(128);
		String newLine = System.getProperty("line.separator");
		sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(newLine);
		sb.append("<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\">");
			sb.append(newLine);
		sb.append("<web-app>").append(newLine).append(newLine);
		sb.append("  <display-name>PutHereTheNameOfYourWebApp</display-name>");
		sb.append(newLine);
		sb.append(newLine);
		sb.append("  <description>This a description of my web app made by Eclipse</description>");
		sb.append(newLine);
		sb.append(newLine);
		NewWebXmlLinkCreationWizardPage.mapAndNameInWebXml(sb, values);
		sb.append("  <welcome-file-list>").append(newLine);
		sb.append("    <welcome-file>");
		sb.append(values.get(MARK_JSP_MAPPING_URL));
		sb.append("</welcome-file>");
		sb.append(newLine);
		sb.append("  </welcome-file-list>").append(newLine).append(newLine);
		sb.append("</web-app>").append(newLine);

		InputStream is = new ByteArrayInputStream(sb.toString().getBytes());
		file.create(is, true, monitor);
		try {
			is.close();
		} catch (IOException e) {
			// TODO Change this
			LogMessage
					.getInstance()
					.log(e.getMessage());
		}
	}

	/**
	 * Adds the naming and mapping for a servlet or jsp object. 
	 * 
	 * @param sb where to add the correct name/map
	 * @param values contains values entered by user
	 */
	private final synchronized static void mapAndNameInWebXml(
		StringBuffer sb,
		Map values) {
		LogMessage
				.getInstance()
				.log(
						"-> NewWebXmlLinkCreationWizardPage.mapAndNameInWebXml(sb, values)");
		// TODO I should use an XML tool. 
		String newLine = System.getProperty("line.separator");
		// Naming 
		String s1 = "</servlet>";
		StringBuffer s2 = new StringBuffer("  <servlet>").append(newLine);
		s2
			.append("    <servlet-name>")
			.append(values.get(MARK_JSP_KEY_NAME))
			.append("</servlet-name>")
			.append(newLine);
		if (!"".equals(values.get(MARK_JSP_DISPLAY_NAME))) {
			s2
				.append("    <display-name>")
				.append(values.get(MARK_JSP_DISPLAY_NAME))
				.append("</display-name>")
				.append(newLine);
		}
		if (!"".equals(values.get(MARK_JSP_DESCRIPTION))) {
			s2
				.append("    <description>")
				.append(values.get(MARK_JSP_DESCRIPTION))
				.append("</description>")
				.append(newLine);
		}
		StringBuffer s6 =
			new StringBuffer("    <servlet-class>")
				.append(values.get(MARK_CLASS_NAME))
				.append("</servlet-class>")
				.append(newLine);
		StringBuffer s6b =
			new StringBuffer("    <jsp-file>")
				.append(values.get(MARK_CLASS_NAME))
				.append("</jsp-file>")
				.append(newLine);
		String s7 = "  </servlet>";

		int lastSM = sb.toString().lastIndexOf(s1);
		if (lastSM == -1) {
			s1 = "</description>";
			lastSM = sb.toString().lastIndexOf(s1);
		}

		if (lastSM == -1) {
			s1 = "</display-name>";
			lastSM = sb.toString().lastIndexOf(s1);
		}

		if (lastSM == -1) {
			s1 = "<web-app>";
			lastSM = sb.toString().lastIndexOf(s1);
		}
		if (lastSM != -1) {
			int id = lastSM + s1.length();
			sb.insert(id, newLine);
			id += newLine.length();
			sb.insert(id, s2);
			id += s2.length();
			if (((String) values.get(MARK_CLASS_NAME)).endsWith(".jsp")) {
				sb.insert(id, s6b);
				id += s6b.length();
			} else {
				sb.insert(id, s6);
				id += s6.length();
			}
			sb.insert(id, s7);
			id += s7.length();
			lastSM = id;
		} else {
			sb.append(s2);
			if (((String) values.get(MARK_CLASS_NAME)).endsWith(".jsp")) {
				sb.append(s6b);
			} else {
				sb.append(s6);
			}
			sb.append(s7);
		}

		// Mapping
		s1 = "</servlet-mapping>";
		s2 =
			new StringBuffer("  <servlet-mapping>").append(newLine).append(
				"    <servlet-name>");
		s2.append(values.get(MARK_JSP_KEY_NAME)).append("</servlet-name>");
		s2.append(newLine).append("    <url-pattern>").append(
			values.get(MARK_JSP_MAPPING_URL));
		s2.append("</url-pattern>").append(newLine).append(
			"  </servlet-mapping>");
		// sb.lastIndexOf is for 1.4 only		
		int id = sb.toString().lastIndexOf(s1);
		if (id != -1) {
			id += s1.length();
		} else {
			id = lastSM;
		}
		sb.insert(id, newLine);
		id += newLine.length();
		sb.insert(id, s2);
	}
	
	/**
	 * Returns the dialog settings.
	 * 
	 * @return the dialog settings
	 */
	public IDialogSettings getDialogSettings() {
		return super.getDialogSettings();
	}

}