package com.aston.wizards.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

import com.aston.AstonWizardsPlugin;
import com.aston.BasicMethodActionICompilationUnit;
import com.aston.BasicMethodActionIFile;
import com.aston.LogMessage;
import com.aston.Marks;
import com.aston.utils.Utils;

/**
 * This is a JSP creation Wizard.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>

 * @version 1.0
 */
public class WebXmlUnMappingDialog extends StatusDialog implements Marks {
	protected final static String SETTINGS_FILE_PATH = "filePath";

	protected BasicMethodActionIFile basicMethodActionIFile;
	protected BasicMethodActionICompilationUnit basicMethodActionICompilationUnit;

	protected Text nameText;
	protected Text filePathText;
 
	protected boolean isPageComplete;
	protected Button browseButton;

	protected Map values = new HashMap(6);

	/**
	 * Constructor of the object.
	 * 
	 * @param parent
	 */
	public WebXmlUnMappingDialog(Shell parent) {
		super(parent);
		LogMessage.getInstance().log(
			"-> WebXmlUnMappingDialog.WebXmlUnMappingDialog(parent)");
	}

	/**
	 * Create a control for this page.
	 */
	protected void createControl() {
		LogMessage.getInstance().log(
			"-> WebXmlUnMappingDialog.createControl()");
		Composite container = (Composite) getDialogArea();
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.makeColumnsEqualWidth = true;
		layout.numColumns = 3;
		layout.verticalSpacing = 9;

		Label label = null;

		ModifyListener ml = new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				WebXmlUnMappingDialog.this.dialogChanged();
			}
		};

		GridData gd = new GridData(GridData.FILL_HORIZONTAL);

		label = new Label(container, SWT.NONE);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.jspname"));
		this.nameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.nameText.setLayoutData(gd);
		this.nameText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		label = new Label(container, SWT.NONE);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.xmlfilepath"));
		this.filePathText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.filePathText.setLayoutData(gd);
		this.filePathText.addModifyListener(ml);
		this.browseButton = new Button(container, SWT.PUSH);
		this.browseButton.setText(
			AstonWizardsPlugin.getResourceString("lg.label.browse"));
		this.browseButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				WebXmlUnMappingDialog.this.handleBrowse();
			}
		});

		dialogChanged();
	}

	public int open() {
		LogMessage.getInstance().log("-> WebXmlUnMappingDialog.open()");
		Shell shell = getShell();
		createControl();
		shell.pack();
		loadSectionValues();
		shell.open();
		Display display = getShell().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		int resu = getReturnCode();
		if (resu == OK) {
			try {
				doFinish();
			} catch (CoreException e1) {
				Utils.showError(e1);
			}
		}
		return getReturnCode();
	}

	/**
	 * Ensures that all is set correctly
	 */
	protected void dialogChanged() {
		LogMessage.getInstance().log(
			"-> WebXmlUnMappingDialog.dialogChanged()");
		setErrorMessage(null);

		if (this.nameText.getText().trim().length() == 0) {
			setErrorMessage(
				AstonWizardsPlugin.getResourceString("lg.warning.namemustbe"));
			return;
		}
		if (this.nameText.getText().trim().indexOf(" ") != -1) {
			setErrorMessage(
				AstonWizardsPlugin.getResourceString("lg.warning.nospacejsp"));
			return;
		}

		AstonWizardsPlugin.getDefault().getPluginPreferences().setValue(
			SETTINGS_FILE_PATH,
			this.filePathText.getText());
		memorizeValues();
	}

	/**
	 * Uses the standard container selection dialog to
	 * choose the new value for the container field.
	 */
	protected void handleBrowse() {
		LogMessage.getInstance().log("-> WebXmlUnMappingDialog.handleBrowse()");
		ContainerSelectionDialog dialog =
			new ContainerSelectionDialog(
				super.getShell(),
				ResourcesPlugin.getWorkspace().getRoot(),
				false,
				AstonWizardsPlugin.getResourceString("lg.label.selectfilepath"));
		if (dialog.open() == ContainerSelectionDialog.OK) {
			Object[] result = dialog.getResult();
			if (result.length == 1) {
				this.filePathText.setText(String.valueOf(result[0]));
			}
		}
	}

	/**
	 * The <code>WizardPage</code> implementation of this method 
	 * declared on <code>DialogPage</code> updates the container
	 * if this is the current page.
	 * 
	 * @param newMessage the error message
	 */
	protected void setErrorMessage(String newMessage) {
		LogMessage.getInstance().log(
			"-> WebXmlUnMappingDialog.setErrorMessage(newMessage)");
		if (newMessage != null) {
			super.updateStatus(new StatusInfo(IStatus.ERROR, newMessage));
		} else {
			super.updateStatus(new StatusInfo(IStatus.OK, null));
		}
	}

	/**
	 * Sets the "old" value in the window.
	 */
	protected void loadSectionValues() {
		LogMessage.getInstance().log(
			"-> WebXmlUnMappingDialog.loadSectionValues()");

		String path = AstonWizardsPlugin.getDefault().getPluginPreferences().getString(SETTINGS_FILE_PATH);
		String description = "This is the description of my J2EE component";
		String display = "This is the display name of my J2EE component";


		if (path == null) {
			if (this.basicMethodActionICompilationUnit != null) {
				path =
					this.basicMethodActionICompilationUnit.getProjectPath()
						+ "/WEB-INF";
			} else if (this.basicMethodActionIFile != null) {
				path = this.basicMethodActionIFile.getProjectPath() + "/WEB-INF";
			}
		}

		if (path != null) {
			// If project name is different then use the new ProjectName
			if (this.basicMethodActionICompilationUnit != null
				&& !Utils.getProjectPath(path).equals(
					this.basicMethodActionICompilationUnit.getProjectPath())) {
				int id = path.indexOf("/", 1);
				if (id != -1) {
					path =
						this
							.basicMethodActionICompilationUnit
							.getProjectPath()
							.concat(
							path.substring(id));
				}
			} else if (
				this.basicMethodActionIFile != null
					&& !Utils.getProjectPath(path).equals(
						this.basicMethodActionIFile.getProjectPath())) {
				int id = path.indexOf("/", 1);
				if (id != -1) {
					path =
						this.basicMethodActionIFile.getProjectPath().concat(
							path.substring(id));
				}
			}
		}

		if (this.basicMethodActionICompilationUnit != null) {
			this.nameText.setText(
				this.basicMethodActionICompilationUnit.getShortClassName());
		} else if (this.basicMethodActionIFile != null) {
			String jspPath =
				Utils.getJspPath(this.basicMethodActionIFile.getGlobalPath());
			String fileName = this.basicMethodActionIFile.getFileName();
			this.nameText.setText(Utils.getJspName(fileName));
		}
		this.filePathText.setText(path);

		//		try {
		//			this.preferenceStore.load();
		//		} catch (IOException e) {
		//		}
		//
		//		String path = this.preferenceStore.getString(SETTINGS_FILE_PATH);
		//
		//		String ppBmx = null;
		//
		//		if (this.basicMethodActionIFile!=null) {
		//			ppBmx = this.basicMethodActionIFile.getProjectPath();
		//		}
		//		if (this.basicMethodActionICompilationUnit!=null) {
		//			ppBmx = this.basicMethodActionICompilationUnit.getProjectPath();
		//		}
		//
		//		if (path==null) {
		//			path = ppBmx;			
		//		}
		//
		//		// Security, read project path in the begining
		//		if (!ppBmx.equals(Utils.getProjectPath(path))) {
		//			int id = path.indexOf("/", 1);
		//			if (id!=-1) {
		//				path = ppBmx.concat(path.substring(id));
		//			}
		//		}
		//
		//		if (this.basicMethodActionIFile==null || !"jsp".equals(this.basicMethodActionIFile.getFileExtension())) {
		//			this.nameText.setText(this.basicMethodActionICompilationUnit.getShortClassName());
		//			if (path == null || "".equals(path)) {
		//				path = Utils.getProjectPath(this.basicMethodActionICompilationUnit.getFilePath()) + "/WEB-INF";
		//			}
		//		} else {
		//			this.nameText.setText(Utils.getJspName(this.basicMethodActionIFile.getFileName()));
		//			if (path == null || "".equals(path)) {
		//				path = Utils.getProjectPath(this.basicMethodActionIFile.getFilePath()) + "/WEB-INF";
		//			}
		//		}
		//		this.filePathText.setText(path);
	}

	public void setBasicMethodActionJsp(BasicMethodActionIFile bma) {
		LogMessage.getInstance().log(
			"-> WebXmlUnMappingDialog.setBasicMethodActionJsp(bma)");
		this.basicMethodActionIFile = bma;
	}

	public void setBasicMethodActionServlet(BasicMethodActionICompilationUnit bmc) {
		LogMessage.getInstance().log(
			"-> WebXmlUnMappingDialog.setBasicMethodActionServlet(bmc)");
		this.basicMethodActionICompilationUnit = bmc;
	}

	/**
	 * Returns the runnable that creates the type using the current settings.
	 * The returned runnable must be executed in the UI thread.
	 */
	protected void memorizeValues() {
		LogMessage.getInstance().log(
			"-> WebXmlUnMappingDialog.memorizeValues()");
		this.values.put(MARK_FILE_PATH, this.filePathText.getText());
		this.values.put(MARK_JSP_KEY_NAME, this.nameText.getText());
	}

	/**
	 * The worker method. It will find the container, create the
	 * file if missing or just replace its contents, and open
	 * the editor on the newly created file.
	 * 
	
	 * @throws CoreException if a problem occured
	 */
	protected void doFinish() throws CoreException {
		LogMessage.getInstance().log("-> WebXmlUnMappingDialog.doFinish()");
		final String fileName = "web.xml";

		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IPath path = new Path((String) this.values.get(MARK_FILE_PATH));
		IResource resource = root.findMember(path);

		// Create the folder if it does not exist
		if (resource == null) {
			CoreUtility.createFolder(root.getFolder(path), true, true, null);
			resource = root.findMember(path);
		}

		IContainer container = (IContainer) resource;
		final IFile file = container.getFile(new Path(fileName));
		InputStream stream = null;
		try {
			if (file.exists()) {
				stream = file.getContents();
				stream = removeMapping(stream, this.values);
				file.setContents(stream, true, true, null);
			} else {
				Utils.showError(
					AstonWizardsPlugin.getResourceString("lg.error.webxmlnotfound"));

			}
		} catch (Exception e) {
			// TODO Change
			LogMessage.getInstance().log(e.getMessage());
		} finally {
			//System.out.println("Closing Stream");
			if (stream!=null) {
				try {
					stream.close();				
				} catch (IOException e1) {
					// TODO Change
					LogMessage.getInstance().log(e1.getMessage());
				}
			}
		}
	}

	/**
	 * We will initialize file contents with a sample text.
	 *
	 * @param in the input stream 
	 * @param values contains values entered by user 
	 * 
	 * @return the input stream that will be used for the creation of the file
	 */
	private InputStream removeMapping(InputStream in, Map values) {
		LogMessage.getInstance().log(
			"-> WebXmlUnMappingDialog.removeMapping(in, values)");
		StringBuffer sb = new StringBuffer(128);
		int c = 0;
		try {
			while ((c = in.read()) != -1) {
				sb.append((char) c);
			}
		} catch (IOException io) {
			throw new RuntimeException(
				AstonWizardsPlugin.getResourceString("lg.error.reading"));
		}
		// Search if mapping and name already exist
		String toSearch =
			"<servlet-name>"
				+ values.get(MARK_JSP_KEY_NAME)
				+ "</servlet-name>";
		String fileC = sb.toString();
		int isHere = fileC.indexOf(toSearch);
		if (isHere == -1) {
			// If mapping does not exist
			Utils.showError(
				AstonWizardsPlugin.getResourceString(
					"lg.error.jspnamepresent3",
					(String) values.get(MARK_JSP_KEY_NAME)));
		} else {
			// If mapping exist
			// 1 - Find the <servlet> ... </servlet> bloc
			int servletOpen =
				fileC.substring(0, isHere).lastIndexOf("<servlet>");
			if (servletOpen != -1) {
				int servletClose = fileC.indexOf("</servlet>", servletOpen);
				// 2 - Find  <servlet-name> ... 	</servlet-name> for MAPPING
				int isHereForMapping = fileC.lastIndexOf(toSearch);
				if (isHereForMapping != -1) {
					// 3 - Find  <servlet-mapping> ... 	</servlet-mapping>
					int servletMappingOpen =
						fileC.substring(0, isHereForMapping).lastIndexOf(
							"<servlet-mapping>");
					if (servletMappingOpen != -1) {
						int servletMappingClose =
							fileC.indexOf(
								"</servlet-mapping>",
								servletMappingOpen);
						if (servletMappingClose != -1) {
							sb.delete(
								servletMappingOpen,
								servletMappingClose
									+ "</servlet-mapping>".length());
						}
					}
					if (servletClose != -1) {
						sb.delete(
							servletOpen,
							servletClose + "</servlet>".length());
					}
				}
			}
		}
		return new ByteArrayInputStream(sb.toString().getBytes());
	}
}
