/*
 * Decompiled with CFR 0.152.
 */
package com.aston;

import com.aston.BasicMethodAction;
import com.aston.LogMessage;
import com.aston.utils.Utils;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BasicMethodActionICompilationUnit
extends BasicMethodAction {
    protected IType selectedClass;
    protected CompilationUnit selectedCompilationUnit;

    protected BasicMethodActionICompilationUnit() {
        LogMessage.getInstance().log("-> BasicMethodActionICompilationUnit.BasicMethodActionICompilationUnit()");
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        LogMessage.getInstance().log("-> BasicMethodActionICompilationUnit.setActivePart(action, targetPart)");
        super.setActivePart(action, targetPart);
        if (this.selection.getFirstElement() instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)this.selection.getFirstElement();
            try {
                IType[] allTypes = cu.getAllTypes();
                int i = 0;
                while (i < allTypes.length) {
                    if (allTypes[i].isClass()) {
                        this.selectedClass = allTypes[i];
                        this.selectedCompilationUnit = cu;
                        return;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    public String getFileName() {
        LogMessage.getInstance().log("-> BasicMethodActionICompilationUnit.getFileName()");
        if (this.selectedClass != null) {
            return this.selectedClass.getElementName().concat(".java");
        }
        return null;
    }

    public String getClassName() {
        LogMessage.getInstance().log("-> BasicMethodActionICompilationUnit.getClassName()");
        if (this.selectedClass != null) {
            return this.selectedClass.getFullyQualifiedName();
        }
        return null;
    }

    public String getShortClassName() {
        LogMessage.getInstance().log("-> BasicMethodActionICompilationUnit.getShortClassName()");
        if (this.selectedClass != null) {
            return this.selectedClass.getElementName();
        }
        return null;
    }

    public String getFilePath() {
        LogMessage.getInstance().log("-> BasicMethodActionICompilationUnit.getFilePath()");
        if (this.selectedClass != null) {
            return this.selectedClass.getPath().toString();
        }
        return null;
    }

    public String getProjectPath() {
        LogMessage.getInstance().log("-> BasicMethodActionICompilationUnit.getProjectPath()");
        return Utils.getProjectPath(this.selectedClass.getPath().toString());
    }
}

