/*
 * Decompiled with CFR 0.152.
 */
package com.aston;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.Marks;
import com.aston.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.ide.IDE;

public abstract class WizardPage
extends org.eclipse.jface.wizard.WizardPage
implements IDialogFieldListener,
Marks {
    protected static final String SETTINGS_TEMPLATE = "template";
    protected static final String SETTINGS_FILE_PATH = "filePath";
    protected Map templatesMap;
    protected IStructuredSelection selection;
    protected Text fileNameText;
    protected Text filePathText;
    protected ComboDialogField templateList;
    protected BooleanFieldEditor generateBool;

    public WizardPage(String pageName, String templateKey) {
        super(pageName);
        LogMessage.getInstance().log("-> WizardPage.WizardPage(pageName, templateKey)");
        this.templatesMap = AstonWizardsPlugin.getDefault().loadTemplateFor(templateKey);
    }

    public WizardPage(String pageName, String title, ImageDescriptor titleImage, String templateKey) {
        super(pageName, title, titleImage);
        LogMessage.getInstance().log("-> WizardPage.WizardPage(pageName, title, titleImage, templateKey)");
        this.templatesMap = AstonWizardsPlugin.getDefault().loadTemplateFor(templateKey);
    }

    public void init(IStructuredSelection selection) {
        LogMessage.getInstance().log("-> WizardPage.init(selection)");
        this.selection = selection;
    }

    public void handleBrowse() {
        Object[] result;
        LogMessage.getInstance().log("-> WizardPage.handleBrowse()");
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, AstonWizardsPlugin.getResourceString("lg.label.selectfilepath"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.filePathText.setText(String.valueOf(result[0]));
        }
    }

    public String getFileName() {
        LogMessage.getInstance().log("-> WizardPage.getFileName()");
        if (this.fileNameText != null) {
            return this.fileNameText.getText();
        }
        return "";
    }

    public String getFilePath() {
        LogMessage.getInstance().log("-> WizardPage.getFilePath()");
        if (this.filePathText != null) {
            return this.filePathText.getText();
        }
        return "";
    }

    public String getTemplateFileName() {
        LogMessage.getInstance().log("-> WizardPage.getTemplateFileName()");
        return (String)this.templatesMap.get(this.templateList.getText());
    }

    /*
     * Exception decompiling
     */
    protected void doFinish(Map values, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 268->271)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateSectionValues() {
        LogMessage.getInstance().log("-> WizardPage.updateSectionValues()");
        if (this.getDialogSettings() == null) {
            return;
        }
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        if (section == null) {
            section = this.getDialogSettings().addNewSection(this.getName());
        }
        if (this.templateList != null) {
            section.put(SETTINGS_TEMPLATE, this.templateList.getText());
        }
        section.put(SETTINGS_FILE_PATH, this.getFilePath());
    }

    protected void dialogChanged() {
        LogMessage.getInstance().log("-> WizardPage.dialogChanged()");
        this.setPageComplete(true);
        this.setErrorMessage(null);
        if (this.generateBool == null || this.generateBool.getBooleanValue()) {
            String fileName = this.getFileName();
            String filePath = this.getFilePath();
            if (this.fileNameText != null && fileName.trim().length() == 0) {
                this.setErrorMessage(AstonWizardsPlugin.getResourceString("lg.warning.filenamemustbespecified"));
                this.setPageComplete(false);
                return;
            }
            if (this.filePathText != null && filePath.trim().length() == 0) {
                this.setErrorMessage(AstonWizardsPlugin.getResourceString("lg.warning.filepathmustbespecified"));
                this.setPageComplete(false);
                return;
            }
            if (this.templateList != null) {
                String template = this.templateList.getText();
                if (template.trim().length() == 0) {
                    this.setErrorMessage(AstonWizardsPlugin.getResourceString("lg.warning.templatenamemustbespecified"));
                    this.setPageComplete(false);
                    return;
                }
                if (this.templatesMap.get(template.trim()) == null) {
                    this.setErrorMessage(AstonWizardsPlugin.getResourceString("lg.warning.templateisnotavailable", template));
                    this.setPageComplete(false);
                    return;
                }
            }
        }
    }

    public String getGlobalPath() {
        LogMessage.getInstance().log("-> WizardPage.getGlobalPath()");
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = this.selection;
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                return container.getFullPath().toString();
            }
            if (obj instanceof Openable) {
                return ((Openable)obj).getPath().toString();
            }
        }
        return "/";
    }

    protected void loadSectionValues() {
        LogMessage.getInstance().log("-> WizardPage.loadSectionValues()");
        if (this.getDialogSettings() == null) {
            return;
        }
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        if (section != null) {
            String temp = section.get(SETTINGS_TEMPLATE);
            String path = this.getGlobalPath();
            if (this.templatesMap != null && this.templateList != null && temp != null && !"".equals(temp)) {
                this.templateList.setText(temp);
            }
            if (this.filePathText != null && path != null && !"".equals(path)) {
                this.filePathText.setText(path);
            }
        }
    }

    public void setVisible(boolean isVisible) {
        LogMessage.getInstance().log("-> WizardPage.setVisible(isVisible)");
        if (isVisible) {
            this.loadSectionValues();
        }
        super.setVisible(isVisible);
    }

    public abstract void createControl(Composite var1);

    public abstract IRunnableWithProgress getRunnable();

    protected void createControlForTemplate(Composite composite, int nColumns) {
        LogMessage.getInstance().log("-> WizardPage.createControlForTemplate(composite, nColumns)");
        this.templateList = new ComboDialogField(2060);
        this.templateList.setItems(Utils.asStringArray(this.templatesMap, true));
        this.templateList.selectItem(0);
        this.templateList.setLabelText(AstonWizardsPlugin.getResourceString("lg.label.temptouse"));
        this.templateList.doFillIntoGrid(composite, nColumns);
        this.templateList.setDialogFieldListener((IDialogFieldListener)this);
    }

    public void dialogFieldChanged(DialogField field) {
        LogMessage.getInstance().log("-> WizardPage.dialogFieldChanged(field)");
        this.dialogChanged();
    }

    protected final void openResource(final IResource file) {
        LogMessage.getInstance().log("-> NewCreationWizard.openResource(file)");
        if (this.getShell() != null && file.getType() == 1) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)file), (boolean)true);
                    }
                    catch (PartInitException e) {
                        JavaPlugin.log((Throwable)e);
                    }
                }
            });
        }
    }

    protected static final class AstonRunnableWithProgress
    implements IRunnableWithProgress {
        protected final Map values;
        protected final WizardPage page;

        public AstonRunnableWithProgress(Map someValues, WizardPage aPage) {
            LogMessage.getInstance().log("-> AstonRunnableWithProgress.AstonRunnableWithProgress(someValues, aPage)");
            this.values = someValues;
            this.page = aPage;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            LogMessage.getInstance().log("-> AstonRunnableWithProgress.run(monitor)");
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                this.page.doFinish(this.values, monitor);
            }
            catch (CoreException e) {
                Utils.showError((Exception)((Object)e), this.page.getShell());
                return;
            }
            this.delete();
        }

        protected void delete() {
            LogMessage.getInstance().log("-> AstonRunnableWithProgress.delete()");
            if (this.values != null) {
                this.values.clear();
            }
        }
    }
}

