/*
 * Decompiled with CFR 0.152.
 */
package com.aston.wizards.designpattern;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewCreationWizard;
import com.aston.utils.Utils;
import com.aston.wizards.designpattern.NewObjectCreationWizardPage;
import java.util.logging.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.wizard.IWizardPage;

public class NewObjectCreationWizard
extends NewCreationWizard {
    private NewObjectCreationWizardPage fPage;

    public NewObjectCreationWizard() {
        LogMessage.getInstance().log("-> NewObjectCreationWizard.NewObjectCreationWizard()");
        Logger.getAnonymousLogger().entering("NewObjectCreationWizard", "NewObjectCreationWizard");
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(AstonWizardsPlugin.getResourceString("lg.label.createobject"));
    }

    public void addPages() {
        LogMessage.getInstance().log("-> NewObjectCreationWizard.addPages()");
        super.addPages();
        this.fPage = new NewObjectCreationWizardPage();
        this.addPage((IWizardPage)this.fPage);
        this.fPage.init(this.getSelection());
    }

    public boolean performFinish() {
        LogMessage.getInstance().log("-> NewObjectCreationWizard.performFinish()");
        try {
            if (this.finishPage(this.fPage.getRunnable())) {
                ICompilationUnit cu = this.fPage.getCreatedType().getCompilationUnit();
                IResource resource = cu.getUnderlyingResource();
                this.selectAndReveal(resource);
                this.openResource(resource);
                return true;
            }
        }
        catch (Exception e) {
            Utils.showError(e, this.getShell());
        }
        return false;
    }
}

