#---------------------------------------------#
# <aw:description>Template for a List with Object</aw:description>
# <aw:version>1.1</aw:version>
# <aw:date>03/18/2004</aw:date>
# <aw:author>Ferret Renaud</aw:author>
#---------------------------------------------#

<aw:import><aw:listType/></aw:import>
<aw:import>java.util.Collection</aw:import>
<aw:import>java.util.Collections</aw:import>
<aw:import>java.util.Comparator</aw:import>
<aw:import>java.util.Iterator</aw:import>
<aw:import>java.util.List</aw:import>
<aw:import>java.util.ListIterator</aw:import>

<aw:interface>java.lang.Cloneable</aw:interface>

<aw:field>
	/** The list. */
	protected List itsList;

</aw:field>

<aw:constructor name="c1">
	/**
	 * Constructor of the object.
	 */
	public <aw:className/>() {
		super();
		this.itsList = new <aw:listType/>();
	}

</aw:constructor>

<aw:constructor name="c2">
	/**
	 * Constructor of the object.
	 * 
	 * @param aCollection the collection whose elements are to be placed into this list.
	 */
	public <aw:className/>(Collection aCollection) {
		super();
		this.itsList = new <aw:listType/>();
		if (aCollection != null) {
			this.itsList.addAll(aCollection);
		}
	}

</aw:constructor>

<aw:method name="size">
	/**
	 * Returns the number of elements in this list. 
	 *
	 * @return the number of elements in this list.
	 */
	public int size() {
		return this.itsList.size();
	}

</aw:method>

<aw:method name="isEmpty">
	/**
	 * Returns <tt>true</tt> if this list contains no elements.
	 *
	 * @return <tt>true</tt> if this list contains no elements.
	 */
	public boolean isEmpty() {
		return this.itsList.isEmpty();
	}

</aw:method>

<aw:method name="iterator">
	/**
	 * Returns an iterator over the elements in this list in proper sequence.
	 *
	 * @return an iterator over the elements in this list in proper sequence.
	 */
	public Iterator iterator() {
		return this.itsList.iterator();
	}

</aw:method>

<aw:method name="containsAll">
	/**
	 * Returns <tt>true</tt> if this list contains all of the elements of the 
	 * specified collection.
	 *
	 * @param aCollection collection to be checked for containment in this list.
	 * @return <tt>true</tt> if this list contains all of the elements of the 
	 * specified collection.
	 * 
	 */
	public boolean containsAll(Collection aCollection) {
		return this.itsList.containsAll(aCollection);
	}

</aw:method>

<aw:method name="addAll1">
	/**
	 * Appends all of the elements in the specified collection to the end of
	 * this list, in the order that they are returned by the specified
	 * collection's iterator.  The behavior of this
	 * operation is unspecified if the specified collection is modified while
	 * the operation is in progress.  (Note that this will occur if the
	 * specified collection is this list, and it's nonempty.)
	 *
	 * @param aCollection collection whose elements are to be added to this list.
	 * @return <tt>true</tt> if this list changed as a result of the call.
	 * 
	 * @throws UnsupportedOperationException if the <tt>addAll</tt> method is not 
	 * supported by this list.
	 * @throws ClassCastException if the class of an element in the specified 
	 * collection prevents it from being added to this list.
	 * @throws IllegalArgumentException if some aspect of an element in the 
	 * specified collection prevents it from being added to this list.
	 */
	public boolean addAll(Collection aCollection) {
		return this.itsList.addAll(aCollection);
	}

</aw:method>

<aw:method name="addAll2">
	/**
	 * Inserts all of the elements in the specified collection into this
	 * list at the specified position.  Shifts the
	 * element currently at that position (if any) and any subsequent
	 * elements to the right (increases their indices).  The new elements
	 * will appear in this list in the order that they are returned by the
	 * specified collection's iterator.  The behavior of this operation is
	 * unspecified if the specified collection is modified while the
	 * operation is in progress.  (Note that this will occur if the specified
	 * collection is this list, and it's nonempty.)
	 *
	 * @param anIndex index at which to insert first element from the specified 
	 * collection.
	 * @param aCollection elements to be inserted into this list.
	 * @return <tt>true</tt> if this list changed as a result of the call.
	 * 
	 * @throws UnsupportedOperationException if the <tt>addAll</tt> method is not 
	 * supported by this list.
	 * @throws ClassCastException if the class of one of elements of the 
	 * specified collection prevents it from being added to this list.
	 * @throws IllegalArgumentException if some aspect of one of elements of 
	 * the specified collection prevents it from being added to this list.
	 * @throws IndexOutOfBoundsException if the index is out of range (index 
	 * &lt; 0 || index &gt; size()).
	 */
	public boolean addAll(int anIndex, Collection aCollection) {
		return this.itsList.addAll(anIndex, aCollection);
	}

</aw:method>

<aw:method name="removeAll">
	/**
	 * Removes from this list all the elements that are contained in the
	 * specified collection.
	 *
	 * @param aCollection collection that defines which elements will be removed 
	 * from this list.
	 * @return <tt>true</tt> if this list changed as a result of the call.
	 * 
	 * @throws UnsupportedOperationException if the <tt>removeAll</tt> method is 
	 * not supported by this list.
	 */
	public boolean removeAll(Collection aCollection) {
		return this.itsList.removeAll(aCollection);
	}

</aw:method>

<aw:method name="retainAll">
	/**
	 * Retains only the elements in this list that are contained in the
	 * specified collection.  In other words, removes
	 * from this list all the elements that are not contained in the specified
	 * collection.
	 *
	 * @param aCollection collection that defines which elements this set will 
	 * retain.
	 * 
	 * @return <tt>true</tt> if this list changed as a result of the call.
	 * 
	 * @throws UnsupportedOperationException if the <tt>retainAll</tt> method is 
	 * not supported by this list.
	 */
	public boolean retainAll(Collection aCollection) {
		return this.itsList.retainAll(aCollection);
	}

</aw:method>

<aw:method name="clear">
	/**
	 * Removes all of the elements from this list. This
	 * list will be empty after this call returns (unless it throws an
	 * exception).
	 *
	 * @throws UnsupportedOperationException if the <tt>clear</tt> method is not 
	 * supported by this list.
	 */
	public void clear() {
		this.itsList.clear();
	}

</aw:method>

<aw:method name="delete">
	/**
	 * Deletes the object
	 *
	 * The object will become unuseable.
	 */
	public void delete() {
		this.itsList.clear();
		this.itsList = null;
	}

</aw:method>

<aw:method name="listIterator1">
	/**
	 * Returns a list iterator of the elements in this list (in proper sequence).
	 *
	 * @return a list iterator of the elements in this list (in proper sequence).
	 */
	public ListIterator listIterator() {
		return this.itsList.listIterator();
	}

</aw:method>

<aw:method name="listIterator2">
	/**
	 * Returns a list iterator of the elements in this list (in proper
	 * sequence), starting at the specified position in this list.  The
	 * specified index indicates the first element that would be returned by
	 * an initial call to the <tt>next</tt> method.  An initial call to
	 * the <tt>previous</tt> method would return the element with the
	 * specified index minus one.
	 *
	 * @param anIndex index of first element to be returned from the list 
	 * iterator (by a call to the <tt>next</tt> method).
	 * 
	 * @return a list iterator of the elements in this list (in proper sequence), 
	 * starting at the specified position in this list.
	 * 
	 * @throws IndexOutOfBoundsException if the index is out of range (index 
	 * &lt; 0 || index &gt; size()).
	 */
	public ListIterator listIterator(int anIndex) {
		return this.itsList.listIterator(anIndex);
	}

</aw:method>

<aw:method name="subList">
	/**
	 * Returns a view of the portion of this list between the specified
	 * <tt>fromIndex</tt>, inclusive, and <tt>toIndex</tt>, exclusive.  (If
	 * <tt>fromIndex</tt> and <tt>toIndex</tt> are equal, the returned list is
	 * empty.)  The returned list is backed by this list, so changes in the
	 * returned list are reflected in this list, and vice-versa.  The returned
	 * list supports all of the optional list operations supported by this
	 * list.<p>
	 *
	 * This method eliminates the need for explicit range operations (of
	 * the sort that commonly exist for arrays).   Any operation that expects
	 * a list can be used as a range operation by passing a subList view
	 * instead of a whole list.  For example, the following idiom
	 * removes a range of elements from a list:
	 * <pre>
	 *	    list.subList(from, to).clear();
	 * </pre>
	 * Similar idioms may be constructed for <tt>indexOf</tt> and
	 * <tt>lastIndexOf</tt>, and all of the algorithms in the
	 * <tt>Collections</tt> class can be applied to a subList.<p>
	 *
	 * The semantics of this list returned by this method become undefined if
	 * the backing list (i.e., this list) is <i>structurally modified</i> in
	 * any way other than via the returned list.  (Structural modifications are
	 * those that change the size of this list, or otherwise perturb it in such
	 * a fashion that iterations in progress may yield incorrect results.)
	 *
	 * @param fromIndex low endpoint (inclusive) of the subList.
	 * @param toIndex high endpoint (exclusive) of the subList.
	 * @return a view of the specified range within this list.
	 * 
	 * @throws IndexOutOfBoundsException for an illegal endpoint index value 
	 * (fromIndex &lt; 0 || toIndex &gt; size || fromIndex &gt; toIndex).
	 */
	public <aw:className/> subList(int fromIndex, int toIndex) {
		if (toIndex - fromIndex >= 0) {
			<aw:className/> res = new <aw:className/>(this.itsList.subList(fromIndex, toIndex));
			return res;
		}
		throw new IndexOutOfBoundsException(" toIndex - fromIndex < 0 ");
	}

</aw:method>

<aw:method name="toString">
	/**
	 * Returns a string representation of the object. In general, the 
	 * <code>toString</code> method returns a string that 
	 * " textually represents " this object.
	 *
	 * @return  a string representation of the object.
	 */
	public String toString() {
		return this.itsList.toString();
	}

</aw:method>

<aw:method name="equals">
	/**
	 * Compares the specified object with this list for equality.  Returns
	 * <tt>true</tt> if and only if the specified object is also a list, both
	 * lists have the same size, and all corresponding pairs of elements in
	 * the two lists are <i>equal</i>.  (Two elements <tt>e1</tt> and
	 * <tt>e2</tt> are <i>equal</i> if <tt>(e1==null ? e2==null :
	 * e1.equals(e2))</tt>.)  In other words, two lists are defined to be
	 * equal if they contain the same elements in the same order.  This
	 * definition ensures that the equals method works properly across
	 * different implementations of the <tt>List</tt> interface.
	 *
	 * @param anObject the object to be compared for equality with this list.
	 * @return <tt>true</tt> if the specified object is equal to this list.
	 */
	public boolean equals(Object anObject) {
		if (anObject == null) {
			return false;
    }
		if (anObject == this) {
			return true;
    }
    // Here we can use == since class object are invariant
    // This method is better than using instanceof since it avoids 
    // inheritance effect
		if (anObject.getClass() == <aw:className/>.class) {
			return this.itsList.equals(anObject);
		}
		return false;
	}

</aw:method>

<aw:method name="clone">
	/**
	 * Creates and returns a copy of this object.  
	 * 
	 * @return a clone of this instance.
	 * @exception CloneNotSupportedException  if the object's class does not 
	 * support the <code>Cloneable</code> interface. Subclasses that override the 
	 * <code>clone</code> method can also throw this exception to indicate that 
	 * an instance cannot be cloned.
	 * @exception OutOfMemoryError if there is not enough memory.
	 */
	public Object clone() {
		<aw:className/> res = new <aw:className/>(this.itsList);
		return res;
	}

</aw:method>

<aw:method name="sort1">
	/**
	 * Sorts the list.
	 */
	public void sort() {
		Collections.sort(this.itsList);
	}

</aw:method>

<aw:method name="sort2">
	/**
	 * Sorts the lis with the help of a comparator.
	 * 
	 * @param aComparator object that tells how to compare objets
	 */
	public void sort(Comparator aComparator) {
		Collections.sort(this.itsList, aComparator);
	}

</aw:method>

<aw:method name="contains">
	/**
	 * Returns <tt>true</tt> if this list contains the specified element.
	 * More formally, returns <tt>true</tt> if and only if this list contains
	 * at least one element <tt>e</tt> such that
	 * <tt>(o==null&nbsp;?&nbsp;e==null&nbsp;:&nbsp;o.equals(e))</tt>.
	 *
	 * @param anElement element whose presence in this list is to be tested.
	 * @return <tt>true</tt> if this list contains the specified element.
	 */
	public boolean contains(<aw:containedTypeEntered/> anElement) {
		return this.itsList.contains(anElement);
	}

</aw:method>

<aw:method name="toArray1">
	/**
	 * Returns an array containing all of the elements in this list in proper
	 * sequence.  Obeys the general contract of the
	 * <tt>Collection.toArray</tt> method.
	 *
	 * @return an array containing all of the elements in this list in proper 
	 * sequence.
	 */
	public <aw:containedTypeEntered/>[] toArray() {
		<aw:containedTypeEntered/>[] res = new <aw:containedTypeEntered/>[this.itsList.size()];
		for (int i = 0; i < this.itsList.size(); i++) {
			res[i] = (<aw:containedTypeEntered/>) this.itsList.get(i);
		}
		return res;
	}

</aw:method>

<aw:method name="toArray2">
	/**
	 * Returns an array containing all of the elements in this list in proper
	 * sequence; the runtime type of the returned array is that of the
	 * specified array.  Obeys the general contract of the
	 * <tt>Collection.toArray(Object[])</tt> method.
	 *
	 * @param someObjects the array into which the elements of this list are to 
	 * be stored, if it is big enough; otherwise, a new array of the same runtime 
	 * type is allocated for this purpose.
	 * @return  an array containing the elements of this list.
	 * 
	 * @throws ArrayStoreException if the runtime type of the specified array is 
	 * not a supertype of the runtime type of every element in this list.
	 */
	public <aw:containedTypeEntered/>[] toArray(<aw:containedTypeEntered/>[] someObjects) {
		<aw:containedTypeEntered/>[] res = new <aw:containedTypeEntered/>[this.itsList.size()];
		System.arraycopy(someObjects, 0, res, 0, this.itsList.size());
		for (int i = 0; i < this.itsList.size(); i++) {
			res[i] = (<aw:containedTypeEntered/>) this.itsList.get(i);
		}
		return res;
	}

</aw:method>

<aw:method name="add1">
	/**
	 * Appends the specified element to the end of this list (optional
	 * operation). <p>
	 *
	 * Lists that support this operation may place limitations on what
	 * elements may be added to this list.  In particular, some
	 * lists will refuse to add null elements, and others will impose
	 * restrictions on the type of elements that may be added.  List
	 * classes should clearly specify in their documentation any restrictions
	 * on what elements may be added.
	 *
	 * @param anElement element to be appended to this list.
	 * @return <tt>true</tt> (as per the general contract of the 
	 * <tt>Collection.add</tt> method).
	 * 
	 * @throws UnsupportedOperationException if the <tt>add</tt> method is not 
	 * supported by this list.
	 * @throws ClassCastException if the class of the specified element prevents 
	 * it from being added to this list.
	 * @throws IllegalArgumentException if some aspect of this element prevents 
	 * it from being added to this collection.
	 */
	public boolean add(<aw:containedTypeEntered/> anElement) {
		return this.itsList.add(anElement);
	}

</aw:method>

<aw:method name="remove">
	/**
	 * Removes the first occurrence in this list of the specified element. If 
	 * this list does not contain the element, it is
	 * unchanged.  More formally, removes the element with the lowest index i
	 * such that <tt>(anElement==null ? get(i)==null : anElement.equals(get(i)))
	 * </tt> (if
	 * such an element exists).
	 *
	 * @param anElement element to be removed from this list, if present.
	 * @return <tt>true</tt> if this list contained the specified element.
	 * 
	 * @throws UnsupportedOperationException if the <tt>remove</tt> method is not 
	 * supported by this list.
	 */
	public boolean remove(<aw:containedTypeEntered/> anElement) {
		return this.itsList.remove(anElement);
	}

</aw:method>

<aw:method name="get">
	/**
	 * Returns the element at the specified position in this list.
	 *
	 * @param anIndex index of element to return.
	 * @return the element at the specified position in this list.
	 * 
	 * @throws IndexOutOfBoundsException if the index is out of range (index 
	 * &lt; 0 || index &gt;= size()).
	 */
	public <aw:containedTypeEntered/> get(int anIndex) {
		return (<aw:containedTypeEntered/>) this.itsList.get(anIndex);
	}

</aw:method>

<aw:method name="set">
	/**
	 * Replaces the element at the specified position in this list with the
	 * specified element.
	 *
	 * @param anIndex index of element to replace.
	 * @param anElement element to be stored at the specified position.
	 * @return the element previously at the specified position.
	 * 
	 * @throws UnsupportedOperationException if the <tt>set</tt> method is not 
	 * supported by this list.
	 * @throws ClassCastException if the class of the specified element prevents 
	 * it from being added to this list.
	 * @throws IllegalArgumentException if some aspect of the specified element 
	 * prevents it from being added to this list.
	 * @throws IndexOutOfBoundsException if the index is out of range (index &lt; 
	 * 0 || index &gt;= size()).  
	 */
	public <aw:containedTypeEntered/> set(int anIndex, <aw:containedTypeEntered/> anElement) {
		return (<aw:containedTypeEntered/>) this.itsList.set(anIndex, anElement);
	}

</aw:method>

<aw:method name="add2">
	/**
	 * Inserts the specified element at the specified position in this list. 
	 * Shifts the element currently at that position
	 * (if any) and any subsequent elements to the right (adds one to their
	 * indices).
	 *
	 * @param anIndex index at which the specified element is to be inserted.
	 * @param anElement element to be inserted.
	 * 
	 * @throws UnsupportedOperationException if the <tt>add</tt> method is not 
	 * supported by this list.
	 * @throws ClassCastException if the class of the specified element prevents 
	 * it from being added to this list.
	 * @throws IllegalArgumentException if some aspect of the specified element 
	 * prevents it from being added to this list.
	 * @throws IndexOutOfBoundsException if the index is out of range (index &lt; 
	 * 0 || index &gt; size()).
	 */
	public void add(int anIndex, <aw:containedTypeEntered/> anElement) {
		this.itsList.add(anIndex, anElement);
	}

</aw:method>

<aw:method name="removeAt">
	/**
	 * Removes the element at the specified position in this list. 
	 * Shifts any subsequent elements to the left (subtracts one
	 * from their indices).  Returns the element that was removed from the
	 * list.
	 *
	 * @param anIndex the index of the element to removed.
	 * @return the element previously at the specified position.
	 * 
	 * @throws UnsupportedOperationException if the <tt>remove</tt> method is not 
	 * supported by this list.
	 * @throws IndexOutOfBoundsException if the index is out of range (index &lt; 
	 * 0 || index &gt;= size()).
	 */
	public <aw:containedTypeEntered/> remove(int anIndex) {
		return (<aw:containedTypeEntered/>) this.itsList.remove(anIndex);
	}

</aw:method>

<aw:method name="indexOf">
	/**
	 * Returns the index in this list of the first occurrence of the specified
	 * element, or -1 if this list does not contain this element.
	 * More formally, returns the lowest index <tt>i</tt> such that
	 * <tt>(anObject==null ? get(i)==null : anObject.equals(get(i)))</tt>,
	 * or -1 if there is no such index.
	 *
	 * @param anElement element to search for.
	 * @return the index in this list of the first occurrence of the specified 
	 * element, or -1 if this list does not contain this element.
	 */
	public int indexOf(<aw:containedTypeEntered/> anElement) {
		return this.itsList.indexOf(anElement);
	}

</aw:method>

<aw:method name="lastIndexOf">
	/**
	 * Returns the index in this list of the last occurrence of the specified
	 * element, or -1 if this list does not contain this element.
	 * More formally, returns the highest index <tt>i</tt> such that
	 * <tt>(anObject==null ? get(i)==null : anObject.equals(get(i)))</tt>,
	 * or -1 if there is no such index.
	 *
	 * @param anElement element to search for.
	 * @return the index in this list of the last occurrence of the specified 
	 * element, or -1 if this list does not contain this element.
	 */
	public int lastIndexOf(<aw:containedTypeEntered/> anElement) {
		return this.itsList.lastIndexOf(anElement);
	}

</aw:method>

<aw:method name="main">
	/**
	 * For test.
	 *
	 * @param args array of arguments
	 */
	public static void main(String[] args) {	
		<aw:className/> myList = new <aw:className/>();
		// Add your value here
		// myList.add(new <aw:containedTypeEntered/>);
		System.out.println(myList);
	}

</aw:method>