#---------------------------------------------#
# <aw:description>Template for a Entity EJB</aw:description>
# <aw:version>1.0</aw:version>
# <aw:date>07/12/2003</aw:date>
# <aw:author>Genuitec, LLC</aw:author>
#---------------------------------------------#

<aw:import>javax.ejb.CreateException</aw:import>
<aw:import>javax.ejb.EJBException</aw:import>
<aw:import>javax.ejb.EntityBean</aw:import>
<aw:import>javax.ejb.EntityContext</aw:import>
<aw:import>javax.ejb.RemoveException</aw:import>

<aw:class-comment name="XDoclet">
/**
 * XDoclet-based CMP entity bean.  This class must be declared
 * <code>public abstract</code> because the concrete class will
 * be implemented by the CMP provider's tooling.<br>
 * 
 * To generate code:
 * <br>
 * <ul>
 * <li> Add Standard EJB module to XDoclet project properties
 * <li> Customize XDoclet configuration
 * <li> Run XDoclet
 * </ul>
 * <br>
 * Please see the included XDoclet Overview 
 * and the XDoclet Reference in the help system for details
 * 
 * @ejb.bean name = "<aw:className/>"
 *           type = "CMP"
 *           cmp-version = "2.x"
 *           display-name = "<aw:className/>"
 *           description = "<aw:className/> EJB"
 *           view-type = "both"
 *           jndi-name = "ejb/<aw:className/>Home"
 *           local-jndi-name = "ejb/<aw:className/>LocalHome"
 *
 * @ejb:util
 *      generate="physical"
 */
</aw:class-comment>

<aw:interface>javax.ejb.EntityBean</aw:interface>

<aw:field>
    /** The EntityContext */
    private EntityContext context;
      
</aw:field>


 
<aw:method name="0required">
	/**
     * There are zero or more ejbCreate&lt;METHOD&gt;(...) methods, whose signatures match
     * the signatures of the create&lt;METHOD&gt;(...) methods of the entity beans home interface.
     * The container invokes an ejbCreate&lt;METHOD&gt;(...) method on an entity bean instance
     * when a client invokes a matching create&lt;METHOD&gt;(...) method on the entity beans
     * home interface.<br>
     * 
     * The entity bean providers responsibility is to initialize the instance in the ejbCreate<
     * METHOD>(...) methods from the input arguments, using the get and set accessor
     * methods, such that when the ejbCreate&lt;METHOD&gt;(...) method returns, the persistent
     * representation of the instance can be created. <br>
     * 
     * The entity bean provider must not attempt to modify the values of cmr-fields in an ejbCreate<
     * METHOD(...) method; this should be done in the ejbPostCreate<METHOD(...) method instead.<br>
     * 
     * The entity object created by the ejbCreate&lt;METHOD&gt; method must have a unique primary
     * key. This means that the primary key must be different from the primary keys of all the existing
     * entity objects within the same home. However, it is legal to reuse the primary key of a previously
     * removed entity object. The implementation of the bean providers ejbCreate<
     * METHOD>(...) methods should be coded to return a null.<br>
     * 
     * An ejbCreate&lt;METHOD&gt;(...) method executes in the transaction context determined by
     * the transaction attribute of the matching create&lt;METHOD&gt;(...) method. 
     * The database insert operations are performed by the container within the same
     * transaction context after the Bean Providers ejbCreate&lt;METHOD&gt;(...) method completes.    
     *
     * @throws CreateException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
     * 
     * @ejb.create-method
     */
    public String ejbCreate() throws CreateException {
        return null;
    }
    
    
</aw:method>


<aw:method name="1required">
    /**
     * For each ejbCreate&lt;METHOD&gt;(...) method, there is a matching ejbPostCreate<
     * METHOD>(...) method that has the same input parameters but whose return type is
     * void. The container invokes the matching ejbPostCreate&lt;METHOD&gt;(...) method on
     * an instance after it invokes the ejbCreate&lt;METHOD&gt;(...) method with the same arguments.
     * The instance can discover the primary key by calling getPrimaryKey() on its
     * entity context object. <br>
     * 
     * The entity object identity is available during the ejbPostCreate&lt;METHOD&gt;(...)
     * method. The instance may, for example, obtain the component interface of the associated entity
     * object and pass it to another enterprise bean as a method argument.<br>
     * 
     * The entity Bean Provider may use the ejbPostCreate&lt;METHOD&gt;(...) to set the values
     * of cmr-fields to complete the initialization of the entity bean instance.
     * An ejbPostCreate&lt;METHOD&gt;(...) method executes in the same transaction context as
     * the previous ejbCreate&lt;METHOD&gt;(...) method.
     *
     * @throws CreateException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
     */
    public void ejbPostCreate() throws CreateException {
    }
    
    
</aw:method>


<aw:method name="2required">
	/**
     * The container invokes this method on the instance when the container picks the instance from
     * the pool and assigns it to a specific entity object identity. The ejbActivate() method gives
     * the entity bean instance the chance to acquire additional resources that it needs while it is in the
     * ready state.<br>
     * 
     * This method executes with an unspecified transaction context. The entity bean must not
     * attempt to access its persistent state or relationships using the accessor methods during this
     * method.<br>
     * 
     * The instance can obtain the identity of the entity object via the getPrimaryKey(), getEJBLocalObject(),
     * or getEJBObject() method on the entity context. The instance
     * can rely on the fact that the primary key and entity object identity will remain associated with
     * the instance until the completion of ejbPassivate() or ejbRemove().
     * 
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
	 */
    public void ejbActivate() throws EJBException {
	}
    
    
</aw:method>


<aw:method name="3required">
    /**
     * The container invokes this method on an instance when the container decides to disassociate
     * the instance from an entity object identity, and to put the instance back into the pool of available
     * instances. The ejbPassivate() method gives the instance the chance to release any
     * resources that should not be held while the instance is in the pool. (These resources typically
     * had been allocated during the ejbActivate() method.) <br>
     * 
     * This method executes with an unspecified transaction context. The entity bean must not
     * attempt to access its persistent state or relationships using the accessor methods during this
     * method.<br>
     * 
     * The instance can still obtain the identity of the entity object via the getPrimaryKey(),
     * getEJBLocalObject(), or getEJBObject() method of the EntityContext interface.
     * 
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
     */
    public void ejbPassivate() throws EJBException {
    }
    
    
</aw:method>


<aw:method name="4required">
    /**
     * When the container needs to synchronize the state of an enterprise bean instance with the
     * entity objects persistent state, the container calls the ejbLoad() method.<br>
     * 
     * The entity Bean Provider can assume that the instances persistent state has been loaded just
     * before the ejbLoad() method is invoked. It is the responsibility of the Bean Provider to use
     * the ejbLoad() method to recompute or initialize the values of any instance variables that
     * depend on the entity beans persistent state. In general, any transient state that depends on the
     * persistent state of an entity bean should be recalculated using the ejbLoad() method. The
     * entity bean can use the ejbLoad() method, for instance, to perform some computation on
     * the values returned by the accessor methods (for example, uncompressing text fields).<br>
     * 
     * This method executes in the transaction context determined by the transaction attribute of the
     * business method that triggered the ejbLoad method. <br>
     * 
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
     */
    public void ejbLoad() throws EJBException {
    }
</aw:method>


<aw:method name="5required">
    /**
     * When the container needs to synchronize the state of the entity objects persistent state with the
     * state of the enterprise bean instance, the container first calls the ejbStore() method on the
     * instance.<br>
     * 
     * The entity Bean Provider should use the ejbStore() method to update the instance using
     * the accessor methods before its persistent state is synchronized. For example, the ejb-
     * Store() method may perform compression of text before the text is stored in the database.
     * The Bean Provider can assume that after the ejbStore() method returns, the persistent state
     * of the instance is synchronized.<br>
     * 
     * This method executes in the same transaction context as the previous ejbLoad or ejbCreate
     * method invoked on the instance. All business methods invoked between the previous
     * ejbLoad or ejbCreate&lt;METHOD&gt; method and this ejbStore method are also invoked
     * in the same transaction context.    
     * 
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
     */
    public void ejbStore() throws EJBException {
    }
</aw:method>


<aw:method name="6required">
    /**
     * The container invokes the ejbRemove() method on an entity bean instance in response to a
     * client-invoked remove operation on the entity beans home or component interface or as the
     * result of a cascade-delete operation. The instance is in the ready state when ejbRemove() is
     * invoked and it will be entered into the pool when the method completes.<br>
     * 
     * The entity bean provider can use the ejbRemove method to implement any actions that must
     * be done before the entity objects persistent representation is removed.
     * The container synchronizes the instances state before it invokes the ejbRemove method.
     * This means that the state of the instance at the beginning of the ejbRemove method is the
     * same as it would be at the beginning of a business method.
     * This method and the database delete operation(s) execute in the transaction context determined
     * by the transaction attribute of the remove method that triggered the ejbRemove method.
     * The instance can still obtain the identity of the entity object via the getPrimaryKey(),
     * getEJBLocalObject(), or getEJBObject() method of the EntityContext interface.<br>
     * 
     * After the entity Bean Providers ejbRemove returns, and in the same transaction context, the
     * Container removes the entity bean from all relationships in which it participates before removing
     * the entity objects persistent representation. <br>
     * Since the instance will be entered into the pool, the state of the instance at the end of this
     * method must be equivalent to the state of a passivated instance. This means that the instance
     * must release any resource that it would normally release in the ejbPassivate() method.
     *  
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
     * 
     * @throws RemoveException Thrown if the enterprise bean does not allow destruction of the object.
     */
    public void ejbRemove() throws EJBException, RemoveException {
    }
    
    
</aw:method>


<aw:method name="7required">
	/**
	 * Set the associated entity context. The container calls this method 
     * after the instance creation. The entity bean must not attempt to 
     * access its persistent state and relationships using the accessor 
     * methods during this method. <br>
	 * 
     * The enterprise bean instance should store the reference to the context 
     * object in an instance variable. <br>
     * 
     * This method is called with no transaction context. 
     * 
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
	 */
    public void setEntityContext(EntityContext newContext) throws EJBException {
		context = newContext;
	}
    
    
</aw:method>


<aw:method name="8required">
    /**
     * Unset the associated entity context. A container invokes this method 
     * before terminating the life of the instance. The entity bean must not 
     * attempt to access its persistent state and relationships using the 
     * accessor methods during this method. <br>
     * 
     * This method is called with no transaction context. 
     * 
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
     */
    public void unsetEntityContext() throws EJBException {
        context = null;
    }
</aw:method>
