#---------------------------------------------#
# <aw:description>Template for a Session EJB</aw:description>
# <aw:version>1.0</aw:version>
# <aw:date>07/12/2003</aw:date>
# <aw:author>Genuitec, LLC</aw:author>
#---------------------------------------------#

<aw:import>javax.ejb.CreateException</aw:import>
<aw:import>javax.ejb.EJBException</aw:import>
<aw:import>javax.ejb.SessionBean</aw:import>
<aw:import>javax.ejb.SessionContext</aw:import>

<aw:class-comment name="XDoclet">
/**
 * XDoclet-based stateless session bean.  The class must be declared
 * <code>public</code>, according to the EJB specification.<br>
 * 
 * To generate code:
 * <br>
 * <ul>
 * <li> Add Standard EJB module to XDoclet project properties</li>
 * <li> Customize XDoclet configuration</li>
 * <li> Run XDoclet</li>
 * </ul>
 * <br>
 * Please see the included XDoclet Overview 
 * and the XDoclet Reference in the help system for details
 * 
 * @ejb.bean name = "<aw:className/>"
 *           type = "Stateless"
 *           display-name = "<aw:className/>"
 *           description = "<aw:className/> EJB"
 *           view-type = "remote"
 *           jndi-name = "ejb/<aw:className/>Home"
 */
</aw:class-comment>

<aw:interface>javax.ejb.SessionBean</aw:interface>

<aw:field>
    /** The SessionContext */
    private SessionContext context;
      
</aw:field>


 
<aw:method name="0required">
	/**
	 * An <code>ejbCreate</code> method as required by the EJB specification. <br>
     * 
     * The container calls the instances <code>ejbCreate</code> method whose 
     * signature matches the signature of the <code>create</code> method invoked 
     * by the client. The input parameters sent from the client are passed to
     * the <code>ejbCreate</code> method. Each session bean class must have at
     * least one <code>ejbCreate</code> method. The number and signatures
     * of a session beans <code>create</code> methods are specific to each 
     * session bean class.
     * 
     * @throws CreateException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
     * 
     * @ejb.create-method
     */
    public void ejbCreate() throws CreateException {
    }
    
    
</aw:method>


<aw:method name="1required">
	/**
	 * The <code>ejbActivate()</code> method as required by the EJB specification.<br>
	 *
	 * The activate method is called when the instance is activated from its 
     * passive" state. The instance should acquire any resource that it has 
     * released earlier in the <code>ejbPassivate()</code> method. <br>
     * 
     * This method is called with no transaction context. 
	 * 
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
	 */
    public void ejbActivate() throws EJBException {
	}
    
    
</aw:method>


<aw:method name="2required">
    /**
     * The <code>ejbPassivate()</code> method as required by the EJB specification.<br>
     *
     * The activate method is called when the instance is activated from 
     * its "passive" state. The instance should acquire any resource that 
     * it has released earlier in the <code>ejbActivate()</code> method.  <br>
     * 
     * This method is called with no transaction context. 
     * 
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
     */
    public void ejbPassivate() throws EJBException {
    }
    
    
</aw:method>


<aw:method name="3required">
    /**
     * The <code>ejbRemove()</code> method as required by the EJB specification.<br>
     *
     * A container invokes this method before it ends the life of the 
     * session object. This happens as a result of a client's invoking 
     * a remove operation, or when a container decides to terminate the 
     * session object after a timeout.   <br>
     * 
     * This method is called with no transaction context. 
     * 
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
     */
    public void ejbRemove() throws EJBException {
    }
    
    
</aw:method>


<aw:method name="4required">
	/**
	 * Set the associated session context. The container calls this method 
     * after the instance creation.  <br>
	 * 
     * The enterprise bean instance should store the reference to the context 
     * object in an instance variable. <br>
     * 
     * This method is called with no transaction context. 
     * 
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
	 */
    public void setSessionContext(SessionContext newContext) throws EJBException {
		context = newContext;
	}
    
    
</aw:method>


<aw:method name="5example">
	/**
	 * An example business method
	 *
	 * @ejb.interface-method view-type = "remote"
     * 
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
	 */
	public void replaceWithRealBusinessMethod() throws EJBException {
		// rename and start putting your business logic here
	}
</aw:method>