/*
 * Decompiled with CFR 0.152.
 */
package com.aston;

import com.aston.AstonWizardsPlugin;
import com.aston.Marks;
import com.aston.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class NewTypeWizardPage
extends org.eclipse.jdt.ui.wizards.NewTypeWizardPage
implements IDialogFieldListener,
Marks {
    protected static final String SETTINGS_CREATE_CONSTR = "create_constructor";
    protected static final String SETTINGS_CREATE_INHERITED = "create_unimplemented";
    protected static final String SETTINGS_CREATE_MAIN = "create_main";
    protected static final String SETTINGS_TEMPLATE = "template";
    protected Map templatesMap;
    protected SelectionButtonDialogFieldGroup fMethodStubsButtons;
    protected ComboDialogField templateList;

    public NewTypeWizardPage(boolean isClass, String pageName, String templateKey) {
        super(isClass, pageName);
        this.templatesMap = AstonWizardsPlugin.getDefault().loadTemplateFor(templateKey);
        this.initThePage();
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
        boolean[] values = new boolean[3];
        int i = 0;
        while (i < values.length) {
            values[i] = true;
            ++i;
        }
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        if (section != null) {
            values[0] = section.getBoolean(SETTINGS_CREATE_INHERITED);
            values[1] = section.getBoolean(SETTINGS_CREATE_MAIN);
            values[2] = section.getBoolean(SETTINGS_CREATE_CONSTR);
        }
        this.setMethodStubSelection(values, true);
    }

    public boolean isCreateInherited() {
        return this.fMethodStubsButtons.isSelected(0);
    }

    public boolean isCreateMain() {
        return this.fMethodStubsButtons.isSelected(1);
    }

    public boolean isCreateConstructors() {
        return this.fMethodStubsButtons.isSelected(2);
    }

    protected void doStatusUpdate() {
        this.setPageComplete(true);
        this.setErrorMessage(null);
        IStatus[] status = new IStatus[]{((NewContainerWizardPage)this).fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
        if (this.isPageComplete() && this.templateList != null) {
            String template = this.templateList.getText();
            if (template.trim().length() == 0) {
                this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.templatenamemustbespecified"));
                this.setPageComplete(false);
                return;
            }
            if (this.templatesMap.get(template.trim()) == null) {
                this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.templateisnotavailable", template));
                this.setPageComplete(false);
                return;
            }
        }
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createControlForTemplate(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
    }

    protected void createControlForTemplate(Composite composite, int nColumns) {
        this.templateList = new ComboDialogField(2060);
        this.templateList.setItems(Utils.asStringArray(this.templatesMap, true));
        this.templateList.setDialogFieldListener((IDialogFieldListener)this);
        this.templateList.selectItem(0);
        this.templateList.setLabelText(AstonWizardsPlugin.getString("lg.label.temptouse"));
        this.templateList.doFillIntoGrid(composite, nColumns);
    }

    protected abstract void initThePage();

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        HashMap<String, String> values = new HashMap<String, String>(5);
        values.put("${TEMPLATE_NAME}", this.getTemplateFileName());
        values.put("<aw:className", this.getTypeName());
        this.setSpecificValues(type, imports, monitor, values);
        this.createInternal(type, imports, monitor, values);
    }

    protected abstract void setSpecificValues(IType var1, NewTypeWizardPage.ImportsManager var2, IProgressMonitor var3, Map var4);

    public void setMethodStubSelection(boolean[] values, boolean canBeModified) {
        int i = 0;
        while (i < values.length) {
            this.fMethodStubsButtons.setSelection(i, values[i]);
            ++i;
        }
        this.fMethodStubsButtons.setEnabled(canBeModified);
    }

    protected void loadSelectionValues() {
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        if (section != null) {
            String temp = section.get(SETTINGS_TEMPLATE);
            if (this.templatesMap != null && this.templateList != null && temp != null && !"".equals(temp)) {
                this.templateList.setText(temp);
            }
        }
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.setFocus();
            this.loadSelectionValues();
        }
        super.setVisible(isVisible);
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
        Label labelControl = this.fMethodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, (int)nColumns);
        DialogField.createEmptySpace((Composite)composite);
        Composite buttonGroup = this.fMethodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, (int)(nColumns - 1));
    }

    public String getTemplateFileName() {
        if (this.templatesMap != null && this.templateList != null) {
            return (String)this.templatesMap.get(this.templateList.getText());
        }
        return null;
    }

    public final String findXmlPart(String file, String markValue) {
        String typeStart = "<".concat(markValue);
        String typeEnd = "</".concat(markValue);
        int start = file.indexOf(typeStart);
        if (start != -1) {
            int end;
            start = file.indexOf(">", start + typeStart.length());
            if ((end = file.indexOf(typeEnd, ++start)) < 0) {
                Utils.showError(AstonWizardsPlugin.getString("lg.error.nonendtag", typeStart), this.getShell());
                return null;
            }
            return file.substring(start, end);
        }
        return null;
    }

    public final Map loadXmlParts(String file, String markValue, String token) {
        TreeMap<String, String> resultat = new TreeMap<String, String>();
        String typeStart = "<".concat(markValue);
        String typeEnd = "</".concat(markValue);
        int start = file.indexOf(typeStart, 0);
        while (start >= 0) {
            int end;
            int startT;
            int endT = start + typeStart.length();
            String tokenValue = null;
            if (token != null && (startT = file.indexOf(token, start + typeStart.length())) >= 0) {
                startT = file.indexOf("=\"", start);
                if (startT < 0) {
                    Utils.showError(AstonWizardsPlugin.getString("lg.error.notoken", token, typeStart), this.getShell());
                    return resultat;
                }
                endT = file.indexOf("\"", startT += 2);
                tokenValue = file.substring(startT, endT);
            }
            if ((end = file.indexOf(typeEnd, start = file.indexOf(">", endT) + 1)) < 0) {
                Utils.showError(AstonWizardsPlugin.getString("lg.error.nonendtag", typeStart), this.getShell());
                return resultat;
            }
            String body = file.substring(start, end);
            if (tokenValue == null) {
                tokenValue = String.valueOf(body.hashCode());
            }
            resultat.put(tokenValue, body);
            start = file.indexOf(typeStart, end);
        }
        return resultat;
    }

    public void refreshSuperClass(boolean force) {
        String sc = super.getSuperClass();
        if (force) {
            sc = this.getSuperClassFromTemplate();
            super.setSuperClass(sc, true);
        }
        if (!force && sc == null || "".equals(sc.trim())) {
            sc = this.getSuperClassFromTemplate();
            super.setSuperClass(sc, true);
        }
    }

    protected void refreshInterfaces(boolean force) {
        List sc = super.getSuperInterfaces();
        if (force) {
            sc = this.getInterfacesFromTemplate();
            super.setSuperInterfaces(sc, true);
        }
        if (!force && sc == null || sc.isEmpty()) {
            sc = this.getInterfacesFromTemplate();
            super.setSuperInterfaces(sc, true);
        }
    }

    protected List getInterfacesFromTemplate() {
        String tName = this.getTemplateFileName();
        ArrayList resu = new ArrayList(5);
        if (tName != null) {
            StringBuffer res;
            try {
                res = AstonWizardsPlugin.getDefault().buildFromTemplate(tName);
            }
            catch (IOException e) {
                return null;
            }
            Map m = this.loadXmlParts(res.toString(), "aw:interface", null);
            resu.addAll(m.values());
            m.clear();
            m = null;
            Object var3_3 = null;
        }
        return resu;
    }

    protected String getSuperClassFromTemplate() {
        String tName = this.getTemplateFileName();
        String resu = "java.lang.Object";
        if (tName != null) {
            StringBuffer res;
            try {
                res = AstonWizardsPlugin.getDefault().buildFromTemplate(tName);
            }
            catch (IOException e) {
                Utils.showError(e, this.getShell());
                return resu;
            }
            String pas = this.findXmlPart(res.toString(), "aw:parentClass");
            if (pas != null) {
                resu = pas;
            }
            Object var3_3 = null;
        }
        return resu;
    }

    protected void createInternal(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, Map values) throws CoreException {
        StringBuffer fileSb = null;
        try {
            fileSb = AstonWizardsPlugin.getDefault().openContentStream(values);
        }
        catch (IOException e) {
            Utils.showError(e, this.getShell());
            return;
        }
        this.createInheritedMethods(type, false, this.isCreateInherited(), imports, monitor);
        String file = fileSb.toString();
        this.createImports(file, type, imports, monitor);
        this.createFields(file, type, imports, monitor);
        if (this.isCreateConstructors()) {
            this.createConstructor(file, type, imports, monitor);
        }
        this.createMethods(file, type, imports, monitor);
        this.createInerType(file, type, imports, monitor);
        this.updateSectionValues();
        if (monitor != null) {
            monitor.done();
        }
    }

    protected void updateSectionValues() {
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        if (section == null) {
            section = this.getDialogSettings().addNewSection(this.getName());
        }
        section.put(SETTINGS_CREATE_INHERITED, this.isCreateInherited());
        section.put(SETTINGS_CREATE_MAIN, this.isCreateMain());
        section.put(SETTINGS_CREATE_CONSTR, this.isCreateConstructors());
        section.put(SETTINGS_TEMPLATE, this.templateList.getText());
    }

    protected void createFields(String file, IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        Map m = this.loadXmlParts(file, "aw:field", null);
        Iterator it = m.values().iterator();
        while (it.hasNext()) {
            String body = (String)it.next();
            type.createField(body, null, false, monitor);
            body = null;
        }
        it = null;
        m.clear();
        m = null;
    }

    protected void createMethods(String file, IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        Map m = this.loadXmlParts(file, "aw:method", "name");
        boolean doMain = this.isCreateMain();
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String body = (String)m.get(key);
            if (!doMain && "main".equals(key)) continue;
            type.createMethod(body, null, false, monitor);
            body = null;
            key = null;
        }
        it = null;
        m.clear();
        m = null;
    }

    protected void createConstructor(String file, IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        Map m = this.loadXmlParts(file, "aw:constructor", "name");
        Iterator it = m.values().iterator();
        while (it.hasNext()) {
            String body = (String)it.next();
            type.createMethod(body, null, false, monitor);
            body = null;
        }
        it = null;
        m.clear();
        m = null;
    }

    protected void createInerType(String file, IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        Map m = this.loadXmlParts(file, "aw:inertype", "name");
        Iterator it = m.values().iterator();
        while (it.hasNext()) {
            String body = (String)it.next();
            type.createType(body, null, false, monitor);
            body = null;
        }
        it = null;
        m.clear();
        m = null;
    }

    protected void createImports(String file, IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        Map m = this.loadXmlParts(file, "aw:import", null);
        Iterator it = m.values().iterator();
        while (it.hasNext()) {
            String body = (String)it.next();
            imports.addImport(body);
            body = null;
        }
        it = null;
        m.clear();
        m = null;
    }

    public void dialogFieldChanged(DialogField field) {
        this.refreshSuperClass(field == this.templateList);
        this.refreshInterfaces(field == this.templateList);
        this.doStatusUpdate();
    }
}

