/*
 * Decompiled with CFR 0.152.
 */
package com.aston;

import com.aston.AstonWizardsPlugin;
import com.aston.Marks;
import com.aston.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public abstract class WizardPage
extends org.eclipse.jface.wizard.WizardPage
implements IDialogFieldListener,
Marks {
    protected static final String SETTINGS_TEMPLATE = "template";
    protected static final String SETTINGS_FILE_PATH = "filePath";
    protected Map templatesMap;
    protected IStructuredSelection selection;
    protected Text fileNameText;
    protected Text filePathText;
    protected ComboDialogField templateList;
    protected BooleanFieldEditor generateBool;

    public WizardPage(String pageName, String templateKey) {
        super(pageName);
        this.templatesMap = AstonWizardsPlugin.getDefault().loadTemplateFor(templateKey);
    }

    public WizardPage(String pageName, String title, ImageDescriptor titleImage, String templateKey) {
        super(pageName, title, titleImage);
        this.templatesMap = AstonWizardsPlugin.getDefault().loadTemplateFor(templateKey);
    }

    public void init(IStructuredSelection selection) {
        this.selection = selection;
    }

    public void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, AstonWizardsPlugin.getString("lg.label.selectfilepath"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.filePathText.setText(String.valueOf(result[0]));
        }
    }

    public String getFileName() {
        if (this.fileNameText != null) {
            return this.fileNameText.getText();
        }
        return "";
    }

    public String getFilePath() {
        if (this.filePathText != null) {
            return this.filePathText.getText();
        }
        return "";
    }

    public String getTemplateFileName() {
        return (String)this.templatesMap.get(this.templateList.getText());
    }

    protected void doFinish(Map values, IProgressMonitor monitor) throws CoreException {
        if (this.generateBool == null || this.generateBool.getBooleanValue()) {
            monitor.beginTask(AstonWizardsPlugin.getString("lg.label.creating", (String)values.get("${FILE_NAME}")), 2);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = root.findMember((IPath)new Path((String)values.get("${FILE_PATH}")));
            if (!resource.exists() || !(resource instanceof IContainer)) {
                Utils.throwCoreException(AstonWizardsPlugin.getString("lg.error.pathdoesnotexist", (String)values.get("${FILE_PATH}")), this.getName());
            }
            IContainer container = (IContainer)resource;
            final IFile file = container.getFile((IPath)new Path((String)values.get("${FILE_NAME}")));
            try {
                StringBuffer sb = AstonWizardsPlugin.getDefault().openContentStream(values);
                ByteArrayInputStream stream = new ByteArrayInputStream(sb.toString().getBytes());
                if (file.exists()) {
                    file.setContents((InputStream)stream, true, true, monitor);
                } else {
                    file.create((InputStream)stream, true, monitor);
                }
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                Utils.showError(e, this.getShell());
                return;
            }
            monitor.worked(1);
            monitor.setTaskName(AstonWizardsPlugin.getString("lg.label.open"));
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        page.openEditor(file);
                    }
                    catch (PartInitException e) {
                        Utils.showError((Exception)((Object)e), WizardPage.this.getShell());
                        return;
                    }
                }
            });
            this.updateSectionValues();
            monitor.worked(1);
        }
    }

    protected void updateSectionValues() {
        if (this.getDialogSettings() == null) {
            return;
        }
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        if (section == null) {
            section = this.getDialogSettings().addNewSection(this.getName());
        }
        if (this.templateList != null) {
            section.put(SETTINGS_TEMPLATE, this.templateList.getText());
        }
        section.put(SETTINGS_FILE_PATH, this.getFilePath());
    }

    protected void dialogChanged() {
        this.setPageComplete(true);
        this.setErrorMessage(null);
        if (this.generateBool == null || this.generateBool.getBooleanValue()) {
            String fileName = this.getFileName();
            String filePath = this.getFilePath();
            if (this.fileNameText != null && fileName.trim().length() == 0) {
                this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.filenamemustbespecified"));
                this.setPageComplete(false);
                return;
            }
            if (this.filePathText != null && filePath.trim().length() == 0) {
                this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.filepathmustbespecified"));
                this.setPageComplete(false);
                return;
            }
            if (this.templateList != null) {
                String template = this.templateList.getText();
                if (template.trim().length() == 0) {
                    this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.templatenamemustbespecified"));
                    this.setPageComplete(false);
                    return;
                }
                if (this.templatesMap.get(template.trim()) == null) {
                    this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.templateisnotavailable", template));
                    this.setPageComplete(false);
                    return;
                }
            }
        }
    }

    public String getGlobalPath() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = this.selection;
            if (ssel.size() > 1) {
                return "/";
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                return container.getFullPath().toString();
            }
            if (obj instanceof Openable) {
                return ((Openable)obj).getPath().toString();
            }
        }
        return "/";
    }

    protected void loadSectionValues() {
        if (this.getDialogSettings() == null) {
            return;
        }
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        if (section != null) {
            String temp = section.get(SETTINGS_TEMPLATE);
            String path = this.getGlobalPath();
            if (this.templatesMap != null && this.templateList != null && temp != null && !"".equals(temp)) {
                this.templateList.setText(temp);
            }
            if (this.filePathText != null && path != null && !"".equals(path)) {
                this.filePathText.setText(path);
            }
        }
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.loadSectionValues();
        }
        super.setVisible(isVisible);
    }

    public abstract void createControl(Composite var1);

    public abstract IRunnableWithProgress getRunnable();

    protected void createControlForTemplate(Composite composite, int nColumns) {
        this.templateList = new ComboDialogField(2060);
        this.templateList.setItems(Utils.asStringArray(this.templatesMap, true));
        this.templateList.selectItem(0);
        this.templateList.setLabelText(AstonWizardsPlugin.getString("lg.label.temptouse"));
        this.templateList.doFillIntoGrid(composite, nColumns);
        this.templateList.setDialogFieldListener((IDialogFieldListener)this);
    }

    public void dialogFieldChanged(DialogField field) {
        this.dialogChanged();
    }

    protected static final class AstonRunnableWithProgress
    implements IRunnableWithProgress {
        protected final Map values;
        protected final WizardPage page;

        public AstonRunnableWithProgress(Map someValues, WizardPage aPage) {
            this.values = someValues;
            this.page = aPage;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                this.page.doFinish(this.values, monitor);
            }
            catch (CoreException e) {
                Utils.showError((Exception)((Object)e), this.page.getShell());
                return;
            }
            this.delete();
        }

        protected void delete() {
            if (this.values != null) {
                this.values.clear();
            }
        }
    }
}

