/*
 * Decompiled with CFR 0.152.
 */
package com.aston.wizards.designpattern;

import com.aston.AstonWizardsPlugin;
import com.aston.NewTypeContainerWizardPage;
import com.aston.NewTypeDoubleContainerWizardPage;
import com.aston.utils.Utils;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NewMapCreationWizardPage
extends NewTypeDoubleContainerWizardPage {
    protected static final String SETTINGS_MAP = "map";
    protected ComboDialogField mapType;

    protected NewMapCreationWizardPage() {
        super(true, "NewMapCreationWizardPage", SETTINGS_MAP);
    }

    protected void doStatusUpdate() {
        super.doStatusUpdate();
        String aMapType = null;
        if (this.mapType != null) {
            aMapType = this.mapType.getText().trim();
        }
        if (this.getSecondContainedClassName() != null && Utils.isBasicType(this.getSecondContainedClassName().trim()) && ((String)Utils.MAP_CLASS.get(2)).equals(aMapType)) {
            this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.weakhm"));
            this.setPageComplete(false);
            return;
        }
        if ("".equals(aMapType)) {
            this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.mapmbs"));
            this.setPageComplete(false);
            return;
        }
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createContainedClassControls(composite, nColumns);
        this.createContainedSecondClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createControlForTemplate(composite, nColumns);
        this.mapType = new ComboDialogField(2052);
        this.mapType.setLabelText(AstonWizardsPlugin.getString("lg.label.maptouse"));
        this.mapType.setItems(Utils.asStringArray(Utils.MAP_CLASS));
        this.mapType.selectItem(0);
        this.mapType.doFillIntoGrid(composite, nColumns);
        this.mapType.setDialogFieldListener((IDialogFieldListener)this);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
    }

    protected void setSpecificValues(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, Map values) {
        super.setSpecificValues(type, imports, monitor, values);
        values.put("<aw:mapType", this.getMapClassName());
    }

    public String getMapClassName() {
        return this.mapType.getText();
    }

    protected void initThePage() {
        this.setTitle(AstonWizardsPlugin.getString("lg.label.mapwizard"));
        this.setDescription(AstonWizardsPlugin.getString("lg.label.mapwillgen"));
        String[] buttonNames3 = new String[]{AstonWizardsPlugin.getString("lg.label.createim"), AstonWizardsPlugin.getString("lg.label.createmain"), AstonWizardsPlugin.getString("lg.label.createc")};
        this.fMethodStubsButtons = new SelectionButtonDialogFieldGroup(32, buttonNames3, 2);
        this.fMethodStubsButtons.setLabelText(AstonWizardsPlugin.getString("lg.label.options"));
        NewTypeContainerWizardPage.TypeFieldsAdapter adapter = new NewTypeContainerWizardPage.TypeFieldsAdapter(this);
        adapter.setDialogTitle(AstonWizardsPlugin.getString("lg.label.choosecontained"));
        adapter.setDialogMessage(AstonWizardsPlugin.getString("lg.label.selectcontained"));
        this.fContainedClassDialogField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fContainedClassDialogField.setLabelText(AstonWizardsPlugin.getString("lg.label.mapvalue"));
        this.fContainedClassDialogField.setButtonLabel(AstonWizardsPlugin.getString("lg.label.select"));
        NewTypeContainerWizardPage.TypeFieldsAdapter adapter2 = new NewTypeContainerWizardPage.TypeFieldsAdapter(this);
        this.fSecondContainedClassDialogField = new StringButtonDialogField((IStringButtonAdapter)adapter2);
        this.fSecondContainedClassDialogField.setLabelText(AstonWizardsPlugin.getString("lg.label.mapkey"));
        this.fSecondContainedClassDialogField.setButtonLabel(AstonWizardsPlugin.getString("lg.label.select"));
        adapter2.setDialogTitle(AstonWizardsPlugin.getString("lg.label.choosecontainedkey"));
        adapter2.setDialogMessage(AstonWizardsPlugin.getString("lg.label.selectcontainedkey"));
        this.fContainedClassDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fSecondContainedClassDialogField.setDialogFieldListener((IDialogFieldListener)adapter2);
    }

    protected void updateSectionValues() {
        super.updateSectionValues();
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        section.put(SETTINGS_MAP, this.mapType.getText());
    }

    protected void loadSelectionValues() {
        super.loadSelectionValues();
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        if (section != null) {
            String temp = section.get(SETTINGS_MAP);
            if (this.mapType != null && temp != null && !"".equals(temp)) {
                this.mapType.setText(temp);
            }
        }
    }
}

